/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.service.jclouds;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.io.IOUtils;
import org.fusesource.fabric.api.CreateContainerOptions;
import org.fusesource.fabric.api.CreateJCloudsContainerMetadata;
import org.fusesource.fabric.api.CreateJCloudsContainerOptions;
import org.fusesource.fabric.api.CreateRemoteContainerOptions;
import org.fusesource.fabric.internal.ContainerProviderUtils;
import org.fusesource.fabric.service.jclouds.JcloudsContainerProvider;
import org.fusesource.fabric.service.jclouds.firewall.FirewallManager;
import org.fusesource.fabric.service.jclouds.firewall.FirewallManagerFactory;
import org.fusesource.fabric.service.jclouds.firewall.FirewallNotSupportedOnProviderException;
import org.fusesource.fabric.service.jclouds.firewall.Rule;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.ssh.SshException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudContainerInstallationTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JcloudsContainerProvider.class);
    private final String containerName;
    private final NodeMetadata nodeMetadata;
    private final CreateJCloudsContainerOptions options;
    private final ComputeService computeService;
    private final FirewallManagerFactory firewallManagerFactory;
    private final TemplateOptions templateOptions;
    private final Set<CreateJCloudsContainerMetadata> result;
    private final CountDownLatch latch;

    public CloudContainerInstallationTask(String containerName, NodeMetadata nodeMetadata, CreateJCloudsContainerOptions options, ComputeService computeService, FirewallManagerFactory firewallManagerFactory, TemplateOptions templateOptions, Set<CreateJCloudsContainerMetadata> result, CountDownLatch latch) {
        this.containerName = containerName;
        this.nodeMetadata = nodeMetadata;
        this.options = options;
        this.computeService = computeService;
        this.firewallManagerFactory = firewallManagerFactory;
        this.templateOptions = templateOptions;
        this.result = result;
        this.latch = latch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String publicAddress2;
            LoginCredentials credentials = this.nodeMetadata.getCredentials();
            credentials = !Strings.isNullOrEmpty((String)this.options.getUser()) && credentials != null ? credentials.toBuilder().user(this.options.getUser()).build() : this.nodeMetadata.getCredentials();
            String id = this.nodeMetadata.getId();
            Set publicAddresses = this.nodeMetadata.getPublicAddresses();
            HashSet<String> copyOfPublicAddresses = new HashSet<String>();
            for (String publicAddress2 : publicAddresses) {
                copyOfPublicAddresses.add(publicAddress2);
            }
            CreateJCloudsContainerMetadata jCloudsContainerMetadata = new CreateJCloudsContainerMetadata();
            jCloudsContainerMetadata.setCreateOptions((CreateContainerOptions)this.options);
            jCloudsContainerMetadata.setNodeId(this.nodeMetadata.getId());
            jCloudsContainerMetadata.setContainerName(this.containerName);
            jCloudsContainerMetadata.setPublicAddresses(copyOfPublicAddresses);
            jCloudsContainerMetadata.setHostname(this.nodeMetadata.getHostname());
            if (credentials != null) {
                jCloudsContainerMetadata.setIdentity(credentials.identity);
                jCloudsContainerMetadata.setCredential(credentials.credential);
            }
            publicAddress2 = "";
            Properties addresses = new Properties();
            if (publicAddresses != null && !publicAddresses.isEmpty()) {
                publicAddress2 = publicAddresses.toArray(new String[publicAddresses.size()])[0];
                addresses.put("publicip", publicAddress2);
            }
            this.options.getSystemProperties().put("addresses", addresses);
            this.options.getMetadataMap().put(this.containerName, jCloudsContainerMetadata);
            try {
                FirewallManager firewallManager = this.firewallManagerFactory.getFirewallManager(this.computeService);
                if (firewallManager.isSupported()) {
                    this.options.getCreationStateListener().onStateChange("Configuring firewall.");
                    String source = this.getOriginatingIp();
                    Rule httpRule = Rule.create().source("0.0.0.0/0").destination(this.nodeMetadata).port(8181);
                    firewallManager.addRules(httpRule);
                    if (source != null) {
                        Rule jmxRule = Rule.create().source(source).destination(this.nodeMetadata).ports(44444, 1099);
                        Rule sshRule = Rule.create().source(source).destination(this.nodeMetadata).port(8101);
                        Rule zookeeperRule = Rule.create().source(source).destination(this.nodeMetadata).port(2181);
                        firewallManager.addRules(jmxRule, sshRule, zookeeperRule);
                    }
                    if (!Strings.isNullOrEmpty((String)publicAddress2)) {
                        Rule zookeeperFromTargetRule = Rule.create().source(publicAddress2 + "/32").destination(this.nodeMetadata).port(2181);
                        firewallManager.addRule(zookeeperFromTargetRule);
                    }
                } else {
                    this.options.getCreationStateListener().onStateChange(String.format("Skipping firewall configuration. Not supported for provider %s", this.options.getProviderName()));
                }
            }
            catch (FirewallNotSupportedOnProviderException e) {
                LOGGER.warn("Firewall manager not supported. Firewall will have to be manually configured.");
            }
            catch (IOException e) {
                LOGGER.warn("Could not lookup originating ip. Firewall will have to be manually configured.", (Throwable)e);
            }
            catch (Throwable t) {
                LOGGER.warn("Failed to setup firewall", t);
            }
            try {
                String script = ContainerProviderUtils.buildInstallAndStartScript((CreateRemoteContainerOptions)((CreateRemoteContainerOptions)this.options.name(this.containerName)));
                this.options.getCreationStateListener().onStateChange(String.format("Installing fabric agent on container %s. It may take a while...", this.containerName));
                ExecResponse response = null;
                try {
                    response = credentials != null ? this.computeService.runScriptOnNode(id, script, (RunScriptOptions)this.templateOptions.overrideLoginCredentials(credentials).runAsRoot(false)) : this.computeService.runScriptOnNode(id, script, (RunScriptOptions)this.templateOptions);
                }
                catch (AuthorizationException ex) {
                    throw new Exception("Failed to connect to the container via ssh.");
                }
                catch (SshException ex) {
                    throw new Exception("Failed to connect to the container via ssh.");
                }
                if (response != null && response.getOutput() != null) {
                    String overridenResolverValue;
                    if (response.getOutput().contains("Command Failed:")) {
                        jCloudsContainerMetadata.setFailure((Throwable)new Exception(ContainerProviderUtils.parseScriptFailure((String)response.getOutput())));
                    }
                    if ((overridenResolverValue = ContainerProviderUtils.parseResolverOverride((String)response.getOutput())) != null) {
                        this.options.setResolver(overridenResolverValue);
                        this.options.getCreationStateListener().onStateChange("Overriding resolver to " + overridenResolverValue + ".");
                    }
                } else {
                    jCloudsContainerMetadata.setFailure((Throwable)new Exception("No response received for fabric install script."));
                }
            }
            catch (Throwable t) {
                jCloudsContainerMetadata.setFailure(t);
            }
            this.options.getSystemProperties().clear();
            this.result.add(jCloudsContainerMetadata);
        }
        finally {
            this.latch.countDown();
        }
    }

    private String getOriginatingIp() throws IOException {
        String ip = null;
        try {
            URL url = new URL("http://checkip.amazonaws.com/");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            ip = IOUtils.toString((InputStream)connection.getInputStream()).trim() + "/32";
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to lookup public ip of current container.");
        }
        return ip;
    }
}

