/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ssh.jsch;

import com.google.common.base.Objects;
import com.google.common.net.HostAndPort;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.util.Arrays;
import java.util.Properties;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ssh.jsch.JschSshClient;
import org.jclouds.util.CredentialUtils;

public class SessionConnection
implements JschSshClient.Connection<Session> {
    private static final byte[] emptyPassPhrase = new byte[0];
    private final HostAndPort hostAndPort;
    private final LoginCredentials loginCredentials;
    private final int connectTimeout;
    private final int sessionTimeout;
    private transient Session session;

    public static Builder builder() {
        return new Builder();
    }

    private SessionConnection(HostAndPort hostAndPort, LoginCredentials loginCredentials, int connectTimeout, int sessionTimeout) {
        this.hostAndPort = hostAndPort;
        this.loginCredentials = loginCredentials;
        this.connectTimeout = connectTimeout;
        this.sessionTimeout = sessionTimeout;
    }

    @Override
    public void clear() {
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
            this.session = null;
        }
    }

    @Override
    public Session create() throws Exception {
        JSch jsch = new JSch();
        this.session = jsch.getSession(this.loginCredentials.getUser(), this.hostAndPort.getHostText(), this.hostAndPort.getPortOrDefault(22));
        if (this.sessionTimeout != 0) {
            this.session.setTimeout(this.sessionTimeout);
        }
        if (this.loginCredentials.getPrivateKey() == null) {
            this.session.setPassword(this.loginCredentials.getPassword());
        } else {
            byte[] privateKey = this.loginCredentials.getPrivateKey().getBytes();
            if (CredentialUtils.isPrivateKeyEncrypted((byte[])privateKey)) {
                throw new IllegalArgumentException("JschSshClientModule does not support private keys that require a passphrase");
            }
            jsch.addIdentity(this.loginCredentials.getUser(), Arrays.copyOf(privateKey, privateKey.length), null, emptyPassPhrase);
        }
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        this.session.setConfig(config);
        this.session.connect(this.connectTimeout);
        return this.session;
    }

    public HostAndPort getHostAndPort() {
        return this.hostAndPort;
    }

    public LoginCredentials getLoginCredentials() {
        return this.loginCredentials;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionConnection that = (SessionConnection)SessionConnection.class.cast(o);
        return Objects.equal((Object)this.hostAndPort, (Object)that.hostAndPort) && Objects.equal((Object)this.loginCredentials, (Object)that.loginCredentials) && Objects.equal((Object)this.session, (Object)that.session);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.hostAndPort, this.loginCredentials, this.session});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("hostAndPort", (Object)this.hostAndPort).add("loginUser", (Object)this.loginCredentials.getUser()).add("session", this.session != null ? Integer.valueOf(this.session.hashCode()) : null).add("connectTimeout", this.connectTimeout).add("sessionTimeout", this.sessionTimeout).toString();
    }

    public static class Builder {
        protected HostAndPort hostAndPort;
        protected LoginCredentials loginCredentials;
        protected int connectTimeout;
        protected int sessionTimeout;

        public Builder hostAndPort(HostAndPort hostAndPort) {
            this.hostAndPort = hostAndPort;
            return this;
        }

        public Builder loginCredentials(LoginCredentials loginCredentials) {
            this.loginCredentials = loginCredentials;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder sessionTimeout(int sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
            return this;
        }

        public SessionConnection build() {
            return new SessionConnection(this.hostAndPort, this.loginCredentials, this.connectTimeout, this.sessionTimeout);
        }

        protected Builder fromSessionConnection(SessionConnection in) {
            return this.hostAndPort(in.getHostAndPort()).connectTimeout(in.getConnectTimeout()).loginCredentials(in.getLoginCredentials());
        }
    }
}

