/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.unix;

import java.io.IOException;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.SshAgentServer;
import org.apache.sshd.agent.unix.AgentClient;
import org.apache.sshd.agent.unix.AgentServerProxy;
import org.apache.sshd.agent.unix.ChannelAgentForwarding;
import org.apache.sshd.common.Channel;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Session;
import org.apache.sshd.server.session.ServerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnixAgentFactory
implements SshAgentFactory {
    @Override
    public NamedFactory<Channel> getChannelForwardingFactory() {
        return new ChannelAgentForwarding.Factory();
    }

    @Override
    public SshAgent createClient(Session session) throws IOException {
        String authSocket = session.getFactoryManager().getProperties().get("SSH_AUTH_SOCK");
        AgentClient agent = new AgentClient(authSocket);
        return agent;
    }

    @Override
    public SshAgentServer createServer(Session session) throws IOException {
        if (!(session instanceof ServerSession)) {
            throw new IllegalStateException("The session used to create an agent server proxy must be a server session");
        }
        return new AgentServerProxy((ServerSession)session);
    }
}

