/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import com.google.common.base.Strings;
import com.google.common.io.InputSupplier;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.AbstractAction;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.karaf.cache.BasicCacheProvider;
import org.jclouds.karaf.cache.CacheProvider;
import org.jclouds.providers.ProviderMetadata;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BlobStoreCommandBase
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlobStoreCommandBase.class);
    public static final String FACTORY_FILTER = "(service.factoryPid=%s)";
    public static final String PROVIDERFORMAT = "%-24s %-12s %-12s";
    protected List<BlobStore> blobStoreServices = new ArrayList<BlobStore>();
    protected CacheProvider cacheProvider = new BasicCacheProvider();
    protected ConfigurationAdmin configAdmin;

    public Object execute(CommandSession session) throws Exception {
        this.session = session;
        return this.doExecute();
    }

    public void setBlobStoreServices(List<BlobStore> services) {
        this.blobStoreServices = services;
    }

    protected List<BlobStore> getBlobStoreServices() {
        return this.blobStoreServices;
    }

    protected Configuration findOrCreateFactoryConfiguration(ConfigurationAdmin configurationAdmin, String factoryPid, String id, String provider, String api) throws IOException {
        Configuration configuration = null;
        if (configurationAdmin != null) {
            try {
                Configuration[] configurations = configurationAdmin.listConfigurations(String.format(FACTORY_FILTER, factoryPid));
                if (configurations != null) {
                    for (Configuration conf : configurations) {
                        Dictionary dictionary = conf.getProperties();
                        if (dictionary != null && id != null) {
                            if (!id.equals(dictionary.get("name"))) continue;
                            return conf;
                        }
                        if (dictionary != null && provider != null && provider.equals(dictionary.get("provider"))) {
                            return conf;
                        }
                        if (dictionary == null || api == null || !api.equals(dictionary.get("api"))) continue;
                        return conf;
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            configuration = configurationAdmin.createFactoryConfiguration(factoryPid, null);
        }
        return configuration;
    }

    public InputSupplier<InputStream> getBlobInputStream(BlobStore blobStore, String containerName, String blobName) throws Exception {
        Blob blob = blobStore.getBlob(containerName, blobName);
        if (blob == null) {
            throw new FileNotFoundException("Blob " + blobName + " does not exist in container " + containerName + ".");
        }
        return blob.getPayload();
    }

    public void write(BlobStore blobStore, String bucket, String blobName, Blob blob) throws Exception {
        String directory;
        if (blobName.contains("/") && !Strings.isNullOrEmpty((String)(directory = BlobStoreUtils.parseDirectoryFromPath((String)blobName)))) {
            blobStore.createDirectory(bucket, directory);
        }
        blobStore.putBlob(bucket, blob);
    }

    protected void printBlobStoreProviders(Iterable<ProviderMetadata> providers, List<BlobStore> blobStores, String indent, PrintStream out) {
        out.println(String.format(PROVIDERFORMAT, "[id]", "[type]", "[service]"));
        for (ProviderMetadata provider : providers) {
            StringBuilder sb = new StringBuilder();
            sb.append("[ ");
            for (BlobStore blobStore : blobStores) {
                String contextName = blobStore.getContext().unwrap().getName();
                if (!blobStore.getContext().unwrap().getId().equals(provider.getId())) continue;
                sb.append(contextName).append(" ");
            }
            sb.append("]");
            out.println(String.format(PROVIDERFORMAT, provider.getId(), "blobstore", sb.toString()));
        }
    }

    protected void printBlobStoreApis(Iterable<ApiMetadata> apis, List<BlobStore> blobStores, String indent, PrintStream out) {
        out.println(String.format(PROVIDERFORMAT, "[id]", "[type]", "[service]"));
        for (ApiMetadata api : apis) {
            StringBuilder sb = new StringBuilder();
            sb.append("[ ");
            for (BlobStore blobStore : blobStores) {
                String contextName = blobStore.getContext().unwrap().getName();
                if (!blobStore.getContext().unwrap().getId().equals(api.getId())) continue;
                sb.append(contextName).append(" ");
            }
            sb.append("]");
            out.println(String.format(PROVIDERFORMAT, api.getId(), "blobstore", sb.toString()));
        }
    }

    public CacheProvider getCacheProvider() {
        return this.cacheProvider;
    }

    public void setCacheProvider(CacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public ConfigurationAdmin getConfigAdmin() {
        return this.configAdmin;
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }
}

