/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.compute;

import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.jclouds.compute.ComputeService;
import org.jclouds.karaf.commands.compute.ComputeCommandWithOptions;

@Command(scope="jclouds", name="node-destroy", description="Destroys the specified nodes.")
public class NodeDestroyCommand
extends ComputeCommandWithOptions {
    @Argument(name="id", description="The ids of the nodes to destroy.", required=true, multiValued=true)
    private List<String> ids;

    protected Object doExecute() throws Exception {
        ComputeService service = null;
        try {
            service = this.getComputeService();
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
            return null;
        }
        for (String id : this.ids) {
            service.destroyNode(id);
            this.cacheProvider.getProviderCacheForType("ACTIVE_NODE_CACHE").remove((Object)service.getContext().unwrap().getId(), (Object)id);
            this.cacheProvider.getProviderCacheForType("INACTIVE_NODE_CACHE").remove((Object)service.getContext().unwrap().getId(), (Object)id);
            this.cacheProvider.getProviderCacheForType("SUSPENDED_NODE_CACHE").remove((Object)service.getContext().unwrap().getId(), (Object)id);
        }
        return null;
    }
}

