/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.compute.completer;

import java.util.List;
import org.jclouds.karaf.cache.Cacheable;
import org.jclouds.karaf.commands.support.GenericCompleterSupport;
import org.jclouds.karaf.recipe.RecipeProvider;

public class RecipeCompleter
extends GenericCompleterSupport<RecipeProvider, String>
implements Cacheable<RecipeProvider> {
    private static final String ANY = "ANY";

    public void init() {
        this.cache = this.cacheProvider.getProviderCacheForType("RECIPE_CACHE");
    }

    @Override
    public int complete(String buffer, int cursor, List<String> candidates) {
        this.delegate.getStrings().clear();
        for (String item : this.cache.values()) {
            if (buffer != null && !item.startsWith(buffer)) continue;
            this.delegate.getStrings().add(item);
        }
        return this.delegate.complete(buffer, cursor, candidates);
    }

    @Override
    public String getCacheableKey(RecipeProvider type) {
        return ANY;
    }

    public void updateOnAdded(RecipeProvider recipeProvider) {
        if (recipeProvider != null) {
            for (String recipe : recipeProvider.listProvidedRecipes()) {
                this.cache.put((Object)ANY, (Object)recipe);
            }
        }
    }
}

