/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.apis.internal;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import com.google.inject.Module;
import java.net.URI;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import org.jclouds.Context;
import org.jclouds.View;
import org.jclouds.apis.ApiMetadata;

public abstract class BaseApiMetadata
implements ApiMetadata {
    private static final long serialVersionUID = -8080028444066498110L;
    protected final String id;
    protected final String name;
    protected final Set<TypeToken<? extends View>> views;
    protected final String endpointName;
    protected final String identityName;
    protected final Optional<String> credentialName;
    protected final String version;
    protected final Optional<String> buildVersion;
    protected final Optional<String> defaultEndpoint;
    protected final Optional<String> defaultIdentity;
    protected final Optional<String> defaultCredential;
    protected final Properties defaultProperties;
    protected final URI documentation;
    protected final TypeToken<? extends Context> context;
    protected final Set<Class<? extends Module>> defaultModules;

    public static Properties defaultProperties() {
        Properties props = new Properties();
        props.setProperty("jclouds.iso3166-codes", "");
        props.setProperty("jclouds.max-connections-per-context", "20");
        props.setProperty("jclouds.max-connections-per-host", "0");
        props.setProperty("jclouds.so-timeout", "60000");
        props.setProperty("jclouds.connection-timeout", "60000");
        props.setProperty("jclouds.io-worker-threads", "20");
        props.setProperty("jclouds.user-threads", "0");
        props.setProperty("jclouds.scheduler-threads", "10");
        props.setProperty("jclouds.max-connection-reuse", "75");
        props.setProperty("jclouds.max-session-failures", "2");
        props.setProperty("jclouds.session-interval", "60");
        props.setProperty("jclouds.payloads.pretty-print", "true");
        return props;
    }

    protected BaseApiMetadata(Builder builder) {
        this(builder.id, builder.name, builder.views, builder.endpointName, builder.identityName, builder.credentialName, builder.version, builder.buildVersion, builder.defaultEndpoint, builder.defaultIdentity, builder.defaultCredential, builder.defaultProperties, builder.documentation, builder.context, builder.defaultModules);
    }

    public BaseApiMetadata(String id, String name, Set<TypeToken<? extends View>> views, String endpointName, String identityName, Optional<String> credentialName, String version, Optional<String> buildVersion, Optional<String> defaultEndpoint, Optional<String> defaultIdentity, Optional<String> defaultCredential, Properties defaultProperties, URI documentation, TypeToken<? extends Context> context, Set<Class<? extends Module>> defaultModules) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.views = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(views, (Object)"views")));
        this.endpointName = (String)Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName");
        this.identityName = (String)Preconditions.checkNotNull((Object)identityName, (Object)"identityName");
        this.credentialName = (Optional)Preconditions.checkNotNull(credentialName, (Object)"credentialName");
        this.version = (String)Preconditions.checkNotNull((Object)version, (Object)"version");
        this.buildVersion = (Optional)Preconditions.checkNotNull(buildVersion, (Object)"buildVersion");
        this.defaultEndpoint = (Optional)Preconditions.checkNotNull(defaultEndpoint, (Object)"defaultEndpoint");
        this.defaultIdentity = (Optional)Preconditions.checkNotNull(defaultIdentity, (Object)"defaultIdentity");
        this.defaultCredential = (Optional)Preconditions.checkNotNull(defaultCredential, (Object)"defaultCredential");
        this.defaultProperties = (Properties)Preconditions.checkNotNull((Object)defaultProperties, (Object)"defaultProperties");
        this.documentation = (URI)Preconditions.checkNotNull((Object)documentation, (Object)"documentation");
        this.context = (TypeToken)Preconditions.checkNotNull(context, (Object)"context");
        this.defaultModules = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(defaultModules, (Object)"defaultModules")));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ApiMetadata)) {
            return false;
        }
        ApiMetadata that = (ApiMetadata)ApiMetadata.class.cast(o);
        return Objects.equal((Object)this.getId(), (Object)that.getId()) && Objects.equal((Object)this.getName(), (Object)that.getName()) && Objects.equal(this.getViews(), that.getViews());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getId(), this.getName(), this.getViews()});
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("views", this.getViews()).add("endpointName", (Object)this.getEndpointName()).add("identityName", (Object)this.getIdentityName()).add("credentialName", this.getCredentialName()).add("documentation", (Object)this.getDocumentation());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<TypeToken<? extends View>> getViews() {
        return this.views;
    }

    @Override
    public String getEndpointName() {
        return this.endpointName;
    }

    @Override
    public String getIdentityName() {
        return this.identityName;
    }

    @Override
    public Optional<String> getCredentialName() {
        return this.credentialName;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Optional<String> getBuildVersion() {
        return this.buildVersion;
    }

    @Override
    public Optional<String> getDefaultEndpoint() {
        return this.defaultEndpoint;
    }

    @Override
    public Optional<String> getDefaultIdentity() {
        return this.defaultIdentity;
    }

    @Override
    public Optional<String> getDefaultCredential() {
        return this.defaultCredential;
    }

    @Override
    public Properties getDefaultProperties() {
        return this.defaultProperties;
    }

    @Override
    public URI getDocumentation() {
        return this.documentation;
    }

    @Override
    public TypeToken<? extends Context> getContext() {
        return this.context;
    }

    @Override
    public Set<Class<? extends Module>> getDefaultModules() {
        return this.defaultModules;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().fromApiMetadata(this);
    }

    public static class Builder
    implements ApiMetadata.Builder {
        protected String id;
        protected String name;
        protected Set<TypeToken<? extends View>> views = ImmutableSet.of();
        protected String endpointName = "https endpoint";
        protected String identityName;
        protected Optional<String> credentialName = Optional.absent();
        protected String version = "";
        protected Optional<String> buildVersion = Optional.of((Object)"");
        protected Optional<String> defaultEndpoint = Optional.absent();
        protected Optional<String> defaultIdentity = Optional.absent();
        protected Optional<String> defaultCredential = Optional.absent();
        protected Properties defaultProperties = BaseApiMetadata.defaultProperties();
        protected URI documentation;
        protected TypeToken<? extends Context> context = TypeToken.of(Context.class);
        protected Set<Class<? extends Module>> defaultModules = ImmutableSet.of();

        @Override
        public Builder id(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            return this;
        }

        @Override
        public Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            return this;
        }

        @Override
        public Builder view(Class<? extends View> view) {
            return this.view(TypeToken.of((Class)((Class)Preconditions.checkNotNull(view, (Object)"view"))));
        }

        @Override
        public Builder view(TypeToken<? extends View> view) {
            return this.views((Set)ImmutableSet.of((Object)Preconditions.checkNotNull(view, (Object)"view")));
        }

        @Override
        public Builder views(Set<TypeToken<? extends View>> views) {
            this.views = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(views, (Object)"views")));
            return this;
        }

        @Override
        public Builder endpointName(String endpointName) {
            this.endpointName = (String)Preconditions.checkNotNull((Object)endpointName, (Object)"endpointName");
            return this;
        }

        @Override
        public Builder identityName(String identityName) {
            this.identityName = (String)Preconditions.checkNotNull((Object)identityName, (Object)"identityName");
            return this;
        }

        @Override
        public Builder credentialName(String credentialName) {
            this.credentialName = Optional.fromNullable((Object)credentialName);
            return this;
        }

        @Override
        public Builder version(String version) {
            this.version = (String)Preconditions.checkNotNull((Object)version, (Object)"version");
            return this;
        }

        @Override
        public Builder buildVersion(String buildVersion) {
            this.buildVersion = Optional.fromNullable((Object)buildVersion);
            return this;
        }

        @Override
        public Builder defaultEndpoint(String defaultEndpoint) {
            this.defaultEndpoint = Optional.fromNullable((Object)defaultEndpoint);
            return this;
        }

        @Override
        public Builder defaultIdentity(String defaultIdentity) {
            this.defaultIdentity = Optional.fromNullable((Object)defaultIdentity);
            return this;
        }

        @Override
        public Builder defaultCredential(String defaultCredential) {
            this.defaultCredential = Optional.fromNullable((Object)defaultCredential);
            return this;
        }

        @Override
        public Builder defaultProperties(Properties defaultProperties) {
            this.defaultProperties = (Properties)Preconditions.checkNotNull((Object)defaultProperties, (Object)"defaultProperties");
            return this;
        }

        @Override
        public Builder documentation(URI documentation) {
            this.documentation = (URI)Preconditions.checkNotNull((Object)documentation, (Object)"documentation");
            return this;
        }

        @Override
        public Builder context(TypeToken<? extends Context> context) {
            this.context = (TypeToken)Preconditions.checkNotNull(context, (Object)"context");
            return this;
        }

        @Override
        public Builder defaultModule(Class<? extends Module> defaultModule) {
            return this.defaultModules((Set)ImmutableSet.of((Object)Preconditions.checkNotNull(defaultModule, (Object)"defaultModule")));
        }

        @Override
        public Builder defaultModules(Set<Class<? extends Module>> defaultModules) {
            this.defaultModules = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(defaultModules, (Object)"defaultModules")));
            return this;
        }

        @Override
        public Builder fromApiMetadata(ApiMetadata in) {
            return ((Builder)((Builder)this.id(in.getId()).views((Set)in.getViews())).name(in.getName()).endpointName(in.getEndpointName()).identityName(in.getIdentityName()).credentialName((String)in.getCredentialName().orNull()).version(in.getVersion()).buildVersion((String)in.getBuildVersion().orNull()).defaultEndpoint((String)in.getDefaultEndpoint().orNull()).defaultIdentity((String)in.getDefaultIdentity().orNull()).defaultCredential((String)in.getDefaultCredential().orNull()).defaultProperties(in.getDefaultProperties()).documentation(in.getDocumentation()).context((TypeToken)in.getContext())).defaultModules((Set)in.getDefaultModules());
        }

        @Override
        public ApiMetadata build() {
            return new BaseApiMetadata(this){
                private static final long serialVersionUID = 3599854558038790678L;
            };
        }
    }
}

