/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cache.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheLoader;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jclouds.cache.ForwardingCacheLoader;
import org.jclouds.cache.internal.BackoffExponentiallyAndRetryOnThrowableCallable;

@Beta
public class BackoffExponentiallyAndRetryOnThrowableCacheLoader<K, V>
extends ForwardingCacheLoader<K, V> {
    private final Class<? extends Throwable> retryableThrowable;
    private final long periodMs;
    private final long maxPeriodMs;
    private final int maxTries;
    private final CacheLoader<K, V> loader;

    public BackoffExponentiallyAndRetryOnThrowableCacheLoader(Class<? extends Throwable> retryableThrowable, long periodMs, long maxPeriodMs, int maxTries, CacheLoader<K, V> loader) {
        this.retryableThrowable = (Class)Preconditions.checkNotNull(retryableThrowable, (Object)"retryableThrowable");
        Preconditions.checkArgument((maxTries > 1 ? 1 : 0) != 0, (String)"maxTries must be more than one: %d", (Object[])new Object[]{maxTries});
        this.maxTries = maxTries;
        Preconditions.checkArgument((periodMs > 0L ? 1 : 0) != 0, (String)"periodMs must be positive: %d", (Object[])new Object[]{periodMs});
        this.periodMs = periodMs;
        Preconditions.checkArgument((maxPeriodMs > periodMs ? 1 : 0) != 0, (String)"maxPeriodMs must be equal to or greater than periodMs: %d %d", (Object[])new Object[]{maxPeriodMs, periodMs});
        this.maxPeriodMs = maxPeriodMs;
        this.loader = (CacheLoader)Preconditions.checkNotNull(loader, (Object)"loader");
    }

    @Override
    protected CacheLoader<K, V> delegate() {
        return this.loader;
    }

    @Override
    public V load(final K key) throws Exception {
        return (V)this.backoffExponentiallyAndRetryOnThrowable(new Callable<V>(){

            @Override
            public V call() throws Exception {
                return BackoffExponentiallyAndRetryOnThrowableCacheLoader.super.load(key);
            }
        });
    }

    @Override
    public ListenableFuture<V> reload(final K key, final V oldValue) throws Exception {
        return (ListenableFuture)this.backoffExponentiallyAndRetryOnThrowable(new Callable<ListenableFuture<V>>(){

            @Override
            public ListenableFuture<V> call() throws Exception {
                return BackoffExponentiallyAndRetryOnThrowableCacheLoader.super.reload(key, oldValue);
            }
        });
    }

    @Override
    public Map<K, V> loadAll(final Iterable<? extends K> keys) throws Exception {
        return (Map)this.backoffExponentiallyAndRetryOnThrowable(new Callable<Map<K, V>>(){

            @Override
            public Map<K, V> call() throws Exception {
                return BackoffExponentiallyAndRetryOnThrowableCacheLoader.super.loadAll(keys);
            }
        });
    }

    private <T> T backoffExponentiallyAndRetryOnThrowable(Callable<T> callable) throws Exception {
        return new BackoffExponentiallyAndRetryOnThrowableCallable<T>(this.retryableThrowable, this.periodMs, this.maxPeriodMs, this.maxTries, callable).call();
    }
}

