/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.concurrent.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.config.DescribedFuture;
import org.jclouds.concurrent.config.DescribingExecutorService;
import org.jclouds.concurrent.config.ExecutorServiceModule;
import org.jclouds.lifecycle.Closer;

public class ScheduledExecutorServiceModule
extends AbstractModule {
    static ScheduledExecutorService addToStringOnSchedule(ScheduledExecutorService executor) {
        if (executor != null) {
            return new DescribingScheduledExecutorService(executor);
        }
        return executor;
    }

    @Provides
    @Singleton
    @Named(value="jclouds.scheduler-threads")
    ScheduledExecutorService provideScheduledExecutor(@Named(value="jclouds.scheduler-threads") int count, Closer closer) {
        return ExecutorServiceModule.shutdownOnClose(ScheduledExecutorServiceModule.addToStringOnSchedule(ScheduledExecutorServiceModule.newScheduledThreadPoolNamed("scheduler thread %d", count)), closer);
    }

    @VisibleForTesting
    static ScheduledExecutorService newScheduledThreadPoolNamed(String name, int maxCount) {
        ThreadFactory factory = new ThreadFactoryBuilder().setNameFormat(name).setThreadFactory(Executors.defaultThreadFactory()).build();
        return maxCount == 0 ? Executors.newSingleThreadScheduledExecutor(factory) : Executors.newScheduledThreadPool(maxCount, factory);
    }

    protected void configure() {
    }

    static class DescribedScheduledFuture<T>
    extends DescribedFuture<T>
    implements ScheduledFuture<T> {
        public DescribedScheduledFuture(ScheduledFuture<T> delegate, String description, StackTraceElement[] submissionTrace) {
            super(delegate, description, submissionTrace);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return ((ScheduledFuture)this.delegate).getDelay(unit);
        }

        @Override
        public int compareTo(Delayed o) {
            return ((ScheduledFuture)this.delegate).compareTo(o);
        }
    }

    static class DescribingScheduledExecutorService
    extends DescribingExecutorService
    implements ScheduledExecutorService {
        public DescribingScheduledExecutorService(ScheduledExecutorService delegate) {
            super(delegate);
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return new DescribedScheduledFuture(((ScheduledExecutorService)this.delegate).schedule(command, delay, unit), command.toString(), ExecutorServiceModule.getStackTraceHere());
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            return new DescribedScheduledFuture<V>(((ScheduledExecutorService)this.delegate).schedule(callable, delay, unit), callable.toString(), ExecutorServiceModule.getStackTraceHere());
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return new DescribedScheduledFuture(((ScheduledExecutorService)this.delegate).scheduleAtFixedRate(command, initialDelay, period, unit), command.toString(), ExecutorServiceModule.getStackTraceHere());
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return new DescribedScheduledFuture(((ScheduledExecutorService)this.delegate).scheduleWithFixedDelay(command, initialDelay, delay, unit), command.toString(), ExecutorServiceModule.getStackTraceHere());
        }
    }
}

