/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.crypto.pem;

import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.RSAPrivateKeyStructure;

public class PKCS1EncodedPrivateKeySpec {
    private RSAPrivateCrtKeySpec keySpec;

    public PKCS1EncodedPrivateKeySpec(byte[] keyBytes) throws IOException {
        this.decode(keyBytes);
    }

    public RSAPrivateKeySpec getKeySpec() {
        return this.keySpec;
    }

    private void decode(byte[] keyBytes) throws IOException {
        ASN1Sequence seq = (ASN1Sequence)ASN1Object.fromByteArray((byte[])keyBytes);
        RSAPrivateKeyStructure rsa = new RSAPrivateKeyStructure(seq);
        BigInteger mod = rsa.getModulus();
        BigInteger pubExp = rsa.getPublicExponent();
        BigInteger privExp = rsa.getPrivateExponent();
        BigInteger p1 = rsa.getPrime1();
        BigInteger p2 = rsa.getPrime2();
        BigInteger exp1 = rsa.getExponent1();
        BigInteger exp2 = rsa.getExponent2();
        BigInteger crtCoef = rsa.getCoefficient();
        this.keySpec = new RSAPrivateCrtKeySpec(mod, pubExp, privExp, p1, p2, exp1, exp2, crtCoef);
    }
}

