/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.handlers;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.http.handlers.RedirectionRetryHandler;

@Singleton
public class DelegatingRetryHandler
implements HttpRetryHandler {
    @Inject(optional=true)
    @Redirection
    @VisibleForTesting
    HttpRetryHandler redirectionRetryHandler;
    @Inject(optional=true)
    @ClientError
    @VisibleForTesting
    HttpRetryHandler clientErrorRetryHandler;
    @Inject(optional=true)
    @ServerError
    @VisibleForTesting
    HttpRetryHandler serverErrorRetryHandler;

    @Inject
    public DelegatingRetryHandler(BackoffLimitedRetryHandler backOff, RedirectionRetryHandler redirectionRetryHandler) {
        this.serverErrorRetryHandler = backOff;
        this.redirectionRetryHandler = redirectionRetryHandler;
        this.clientErrorRetryHandler = HttpRetryHandler.NEVER_RETRY;
    }

    @Override
    public boolean shouldRetryRequest(HttpCommand command, HttpResponse response) {
        int statusCode = response.getStatusCode();
        boolean retryRequest = false;
        if (statusCode >= 300 && statusCode < 400) {
            retryRequest = this.redirectionRetryHandler.shouldRetryRequest(command, response);
        } else if (statusCode >= 400 && statusCode < 500) {
            retryRequest = this.clientErrorRetryHandler.shouldRetryRequest(command, response);
        } else if (statusCode >= 500) {
            retryRequest = this.serverErrorRetryHandler.shouldRetryRequest(command, response);
        }
        return retryRequest;
    }

    public HttpRetryHandler getRedirectionRetryHandler() {
        return this.redirectionRetryHandler;
    }

    public HttpRetryHandler getClientErrorRetryHandler() {
        return this.clientErrorRetryHandler;
    }

    public HttpRetryHandler getServerErrorRetryHandler() {
        return this.serverErrorRetryHandler;
    }
}

