/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FilterStringsBoundToInjectorByName
implements Function<Predicate<String>, Map<String, String>> {
    private final Injector injector;

    @Inject
    public FilterStringsBoundToInjectorByName(Injector injector) {
        this.injector = (Injector)Preconditions.checkNotNull((Object)injector, (Object)"injector");
    }

    public Map<String, String> apply(Predicate<String> filter) {
        List stringBindings = this.injector.findBindingsByType((TypeLiteral)new TypeLiteral<String>(){});
        Iterable annotatedWithName = Iterables.filter((Iterable)stringBindings, (Predicate)new Predicate<Binding<String>>(){

            public boolean apply(Binding<String> input) {
                Annotation annotation = input.getKey().getAnnotation();
                if (annotation == null) {
                    return false;
                }
                return annotation instanceof javax.inject.Named || annotation instanceof Named;
            }
        });
        ImmutableMap bindingsByName = Maps.uniqueIndex((Iterable)annotatedWithName, (Function)new Function<Binding<String>, String>(){

            public String apply(Binding<String> input) {
                Annotation annotation = input.getKey().getAnnotation();
                return annotation instanceof javax.inject.Named ? ((javax.inject.Named)javax.inject.Named.class.cast(annotation)).value() : ((Named)Named.class.cast(annotation)).value();
            }
        });
        Map filteredBindingsByName = Maps.filterKeys((Map)bindingsByName, filter);
        Map stringBoundByName = Maps.transformValues((Map)filteredBindingsByName, (Function)new Function<Binding<String>, String>(){

            public String apply(Binding<String> input) {
                return (String)input.getProvider().get();
            }
        });
        return stringBoundByName;
    }
}

