/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.config;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.io.InputSupplier;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.TransformingMap;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.io.CopyInputStreamInputSupplierMap;
import org.jclouds.json.Json;
import org.jclouds.logging.Logger;
import org.jclouds.rest.ConfiguresCredentialStore;
import org.jclouds.util.Strings2;

@ConfiguresCredentialStore
@Beta
public class CredentialStoreModule
extends AbstractModule {
    private static final Map<String, InputSupplier<InputStream>> BACKING = new ConcurrentHashMap<String, InputSupplier<InputStream>>();
    private final Map<String, InputStream> backing;

    public CredentialStoreModule(Map<String, InputStream> backing) {
        this.backing = backing;
    }

    public CredentialStoreModule() {
        this(null);
    }

    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<Function<Credentials, InputStream>>(){}).to(CredentialsToJsonInputStream.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<InputStream, Credentials>>(){}).to(CredentialsFromJsonInputStream.class);
        if (this.backing != null) {
            this.bind((TypeLiteral)new TypeLiteral<Map<String, InputStream>>(){}).toInstance(this.backing);
        } else {
            this.bind((TypeLiteral)new TypeLiteral<Map<String, InputSupplier<InputStream>>>(){}).toInstance(BACKING);
            this.bind((TypeLiteral)new TypeLiteral<Map<String, InputStream>>(){}).to((TypeLiteral)new TypeLiteral<CopyInputStreamInputSupplierMap>(){});
        }
    }

    @Provides
    @Singleton
    protected Map<String, Credentials> provideCredentialStore(Map<String, InputStream> backing, Function<Credentials, InputStream> credentialsSerializer, Function<InputStream, Credentials> credentialsDeserializer) {
        return new TransformingMap<String, InputStream, Credentials>(backing, credentialsDeserializer, credentialsSerializer);
    }

    @Singleton
    public static class CredentialsFromJsonInputStream
    implements Function<InputStream, Credentials> {
        @Resource
        protected Logger logger = Logger.NULL;
        private final Json json;

        @Inject
        CredentialsFromJsonInputStream(Json json) {
            this.json = json;
        }

        public Credentials apply(InputStream from) {
            try {
                String creds = Strings2.toStringAndClose((InputStream)Preconditions.checkNotNull((Object)from));
                if (creds.indexOf("\"user\":") == -1) {
                    return this.json.fromJson(creds, Credentials.class);
                }
                JsonLoginCredentials val = this.json.fromJson(creds, JsonLoginCredentials.class);
                return LoginCredentials.builder().user(val.user).password(val.password).privateKey(val.privateKey).authenticateSudo(Boolean.TRUE.equals(val.authenticateSudo)).build();
            }
            catch (Exception e) {
                this.logger.warn(e, "ignoring problem retrieving credentials", new Object[0]);
                return null;
            }
        }
    }

    static class JsonLoginCredentials {
        private String user;
        private String password;
        private String privateKey;
        private Boolean authenticateSudo;

        JsonLoginCredentials() {
        }
    }

    @Singleton
    public static class CredentialsToJsonInputStream
    implements Function<Credentials, InputStream> {
        private final Json json;

        @Inject
        CredentialsToJsonInputStream(Json json) {
            this.json = json;
        }

        public InputStream apply(Credentials from) {
            Preconditions.checkNotNull((Object)from, (Object)"inputCredentials");
            if (from instanceof LoginCredentials) {
                LoginCredentials login = (LoginCredentials)LoginCredentials.class.cast(from);
                JsonLoginCredentials val = new JsonLoginCredentials();
                val.user = login.getUser();
                val.password = login.getPassword();
                val.privateKey = login.getPrivateKey();
                if (login.shouldAuthenticateSudo()) {
                    val.authenticateSudo = login.shouldAuthenticateSudo();
                }
                return Strings2.toInputStream(this.json.toJson(val));
            }
            return Strings2.toInputStream(this.json.toJson(from));
        }
    }
}

