/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.util;

import com.google.common.base.Preconditions;
import org.jclouds.domain.Credentials;
import org.jclouds.javax.annotation.Nullable;

public class CredentialUtils {
    public static Credentials overrideCredentialsIfSupplied(Credentials defaultCredentials, @Nullable Credentials overridingCredentials) {
        if (overridingCredentials == null) {
            return defaultCredentials;
        }
        String identity = overridingCredentials.identity != null ? overridingCredentials.identity : ((Credentials)Preconditions.checkNotNull((Object)defaultCredentials, (Object)"defaultCredentials")).identity;
        String credential = overridingCredentials.credential != null ? overridingCredentials.credential : ((Credentials)Preconditions.checkNotNull((Object)defaultCredentials, (Object)"defaultCredentials")).credential;
        return new Credentials(identity, credential);
    }

    public static boolean isPrivateKeyCredential(Credentials credentials) {
        return credentials != null && CredentialUtils.isPrivateKeyCredential(credentials.credential);
    }

    public static boolean isPrivateKeyCredential(String credential) {
        return credential != null && (credential.startsWith("-----BEGIN RSA PRIVATE KEY-----") || credential.startsWith("-----BEGIN PRIVATE KEY-----"));
    }

    public static boolean isPrivateKeyEncrypted(byte[] privateKey) {
        return new String(privateKey).contains("Proc-Type: 4,ENCRYPTED");
    }
}

