/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.commands.ContainerLifecycleCommand;
import org.fusesource.fabric.utils.FabricValidations;

@Command(name="container-stop", scope="fabric", description="Shut down an existing container", detailedDescription="classpath:containerStop.txt")
public class ContainerStop
extends ContainerLifecycleCommand {
    @Option(name="-f", aliases={"--force"}, multiValued=false, required=false, description="Forces stopping of the container.")
    protected Boolean force = Boolean.FALSE;

    protected Object doExecute() throws Exception {
        this.checkFabricAvailable();
        FabricValidations.validateContainersName(this.container);
        if (this.isPartOfEnsemble(this.container) && !this.force.booleanValue()) {
            System.out.println("Container is part of the ensemble. If you still want to stop it, please use -f option.");
            return null;
        }
        Container found = this.getContainer(this.container);
        this.applyUpdatedCredentials(found);
        if (found.isAlive()) {
            found.stop();
        } else {
            System.err.println("Container " + this.container + " is already stopped");
        }
        return null;
    }
}

