/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.CreateEnsembleOptions;
import org.fusesource.fabric.boot.commands.support.EnsembleCommandSupport;
import org.fusesource.fabric.utils.FabricValidations;

@Command(name="ensemble-add", scope="fabric", description="Extend the current fabric ensemble by converting the specified containers into ensemble servers", detailedDescription="classpath:ensembleAdd.txt")
public class EnsembleAdd
extends EnsembleCommandSupport {
    @Option(name="--generate-zookeeper-password", multiValued=false, description="Flag to enable automatic generation of password")
    private boolean generateZookeeperPassword = false;
    @Option(name="--new-zookeeper-password", multiValued=false, description="The ensemble new password to use (defaults to the old one)")
    private String zookeeperPassword;
    @Option(name="-f", aliases={"--force"}, multiValued=false, description="Flag to force the addition without prompt")
    private boolean force = false;
    @Argument(required=true, multiValued=true, description="List of containers to be added")
    private List<String> containers;

    protected Object doExecute() throws Exception {
        this.checkFabricAvailable();
        FabricValidations.validateContainersName(this.containers);
        if (this.checkIfShouldModify(this.session, this.force)) {
            if (this.containers != null && !this.containers.isEmpty()) {
                CreateEnsembleOptions options;
                StringBuilder builder = new StringBuilder();
                builder.append("Adding containers:");
                for (String container : this.containers) {
                    builder.append(" ").append(container);
                }
                builder.append(" to the ensemble. This may take a while.");
                System.out.println(builder.toString());
                if (this.generateZookeeperPassword) {
                    options = CreateEnsembleOptions.build();
                    this.service.addToCluster(this.containers, options);
                } else if (this.zookeeperPassword == null || this.zookeeperPassword.isEmpty()) {
                    this.service.addToCluster(this.containers);
                } else {
                    options = CreateEnsembleOptions.build().zookeeperPassword(this.zookeeperPassword);
                    this.service.addToCluster(this.containers, options);
                }
            }
            System.out.println("Updated Zookeeper connection string: " + this.service.getZooKeeperUrl());
        }
        return null;
    }
}

