/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.io.File;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.boot.commands.support.FabricCommand;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.fusesource.fabric.zookeeper.utils.RegexSupport;
import org.fusesource.fabric.zookeeper.utils.ZookeeperImportUtils;

@Command(name="import", scope="fabric", description="Import data either from a filesystem or from a properties file into the fabric registry (ZooKeeper tree)", detailedDescription="classpath:import.txt")
public class Import
extends FabricCommand {
    @Argument(description="Location of a filesystem (if --filesystem is specified) or a properties file (if --properties is specified).")
    protected String source = System.getProperty("karaf.home") + File.separator + "fabric" + File.separator + "import";
    @Option(name="-d", aliases={"--delete"}, description="Delete any paths not in the tree being imported. Ignored when importing a properties file. CAUTION: Using this option could permanently delete all or part of the fabric registry.")
    boolean delete = false;
    @Option(name="-t", aliases={"--target"}, description="Path of the znode that the data is imported into.")
    String target = "/";
    @Option(name="-props", aliases={"--properties"}, description="Indicates that the 'source' argument is a properties file.")
    boolean properties = false;
    @Option(name="-fs", aliases={"--filesystem"}, description="Indicates that the 'source' argument is a directory on the filesystem.")
    boolean filesystem = true;
    @Option(name="-v", aliases={"--verbose"}, description="Verbose output of files being imported")
    boolean verbose = false;
    @Option(name="-f", aliases={"--regex"}, description="Specifies a regular expression that matches the znode paths you want to include in the import. For multiple include expressions, specify this option multiple times. The regular expression syntax is defined by the java.util.regex package.", multiValued=true)
    String[] regex;
    @Option(name="-rf", aliases={"--reverse-regex"}, description="Specifies a regular expression that matches the znode paths you want to exclude from the import. For multiple exclude expressions, specify this option multiple times. The regular expression syntax is defined by the java.util.regex package.", multiValued=true)
    protected String[] nregex;
    @Option(name="--dry-run", description="Log the actions that would be performed during an import, but do not actually perform the import.")
    boolean dryRun = false;
    File ignore = new File(".fabricignore");
    File include = new File(".fabricinclude");

    protected void doExecute(IZKClient zk) throws Exception {
        if (this.ignore.exists() && this.ignore.isFile()) {
            this.nregex = RegexSupport.merge((File)this.ignore, (String[])this.nregex);
        }
        if (this.include.exists() && this.include.isFile()) {
            this.regex = RegexSupport.merge((File)this.include, (String[])this.regex);
        }
        if (this.properties) {
            this.filesystem = false;
        }
        if (this.filesystem) {
            this.properties = false;
        }
        if (this.properties) {
            ZookeeperImportUtils.importFromPropertiesFile((IZKClient)zk, (String)this.source, (String)this.target, (String[])this.regex, (String[])this.nregex, (boolean)this.dryRun);
        }
        if (this.filesystem) {
            ZookeeperImportUtils.importFromFileSystem((IZKClient)zk, (String)this.source, (String)this.target, (String[])this.regex, (String[])this.nregex, (boolean)this.delete, (boolean)this.dryRun, (boolean)this.verbose);
        }
        System.out.println("imported ZK data from: " + this.source);
    }

    public boolean isFilesystem() {
        return this.filesystem;
    }

    public void setFilesystem(boolean filesystem) {
        this.filesystem = filesystem;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected Object doExecute() throws Exception {
        this.doExecute(this.getZooKeeper());
        return null;
    }
}

