/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands.hadoop;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.CreateContainerBasicOptions;
import org.fusesource.fabric.api.CreateContainerChildOptions;
import org.fusesource.fabric.api.CreateContainerMetadata;
import org.fusesource.fabric.api.CreateContainerOptions;
import org.fusesource.fabric.api.CreateContainerOptionsBuilder;
import org.fusesource.fabric.api.FabricService;
import org.fusesource.fabric.api.Profile;

@Command(scope="hadoop", name="create", description="Create an hadoop cluster")
public class Create
extends OsgiCommandSupport {
    @Option(name="--name")
    private String name = "default";
    @Option(name="--name-node")
    private String nameNode = "namenode";
    @Option(name="--secondary-name-node")
    private String secondaryNameNode;
    @Option(name="--data-nodes")
    private List<String> dataNodes = Collections.singletonList("datanode");
    @Option(name="--job-tracker")
    private String jobTracker;
    @Option(name="--task-trackers")
    private List<String> taskTrackers = Collections.emptyList();
    @Option(name="--create-children")
    private boolean createChildren = false;
    @Option(name="--force")
    private boolean force = false;
    private FabricService service;

    public FabricService getService() {
        return this.service;
    }

    public void setService(FabricService service) {
        this.service = service;
    }

    protected Object doExecute() throws Exception {
        Container cont;
        Container[] containers = this.service.getContainers();
        if (this.nameNode == null || this.dataNodes.isEmpty()) {
            throw new IllegalArgumentException("The name node and at least one data node must be specified");
        }
        if (!this.taskTrackers.isEmpty() && this.jobTracker == null) {
            throw new IllegalArgumentException("Can not specify task trackers if no job tracker is specified");
        }
        if (this.taskTrackers.isEmpty() && this.jobTracker != null) {
            throw new IllegalArgumentException("At least one task tracker node must be specified");
        }
        if (!this.createChildren) {
            if (this.findContainer(containers, this.nameNode) == null) {
                throw new IllegalStateException("Container " + this.nameNode + " does not exists");
            }
            if (this.secondaryNameNode != null && this.findContainer(containers, this.secondaryNameNode) == null) {
                throw new IllegalStateException("Container " + this.secondaryNameNode + " does not exists");
            }
            for (String n : this.dataNodes) {
                if (this.findContainer(containers, n) != null) continue;
                throw new IllegalStateException("Container " + n + " does not exists");
            }
            if (this.jobTracker != null && this.findContainer(containers, this.jobTracker) == null) {
                throw new IllegalStateException("Container " + this.jobTracker + " does not exists");
            }
            for (String n : this.taskTrackers) {
                if (this.findContainer(containers, n) != null) continue;
                throw new IllegalStateException("Container " + n + " does not exists");
            }
        }
        for (String p : Arrays.asList("hadoop-" + this.name, "hadoop-" + this.name + "-namenode", "hadoop-" + this.name + "-secondary-namenode", "hadoop-" + this.name + "-datanode", "hadoop-" + this.name + "-job-tracker", "hadoop-" + this.name + "-task-tracker", "insight-hdfs-" + this.name)) {
            Profile profile = null;
            try {
                profile = this.service.getProfile(this.service.getDefaultVersion().getName(), p);
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (profile == null) continue;
            if (this.force) {
                profile.delete();
                continue;
            }
            throw new IllegalStateException("Profile " + profile.getId() + " already exists. Use --force to recreate the profiles.");
        }
        String version = this.service.getDefaultVersion().getName();
        Profile hadoop = this.service.getProfile(version, "hadoop");
        Profile cluster = this.service.createProfile(this.service.getDefaultVersion().getName(), "hadoop-" + this.name);
        cluster.setParents(new Profile[]{hadoop});
        HashMap configs = new HashMap();
        configs.put("org.fusesource.fabric.hadoop", new HashMap());
        ((Map)configs.get("org.fusesource.fabric.hadoop")).put("fs.default.name", "hdfs://${zk:" + this.nameNode + "/ip}:9000");
        ((Map)configs.get("org.fusesource.fabric.hadoop")).put("dfs.http.address", "hdfs://${zk:" + this.nameNode + "/ip}:9002");
        cluster.setConfigurations(configs);
        Profile nameNodeProfile = this.service.createProfile(this.service.getDefaultVersion().getName(), "hadoop-" + this.name + "-namenode");
        nameNodeProfile.setParents(new Profile[]{cluster});
        configs = new HashMap();
        configs.put("org.fusesource.fabric.hadoop", new HashMap());
        ((Map)configs.get("org.fusesource.fabric.hadoop")).put("nameNode", "true");
        nameNodeProfile.setConfigurations(configs);
        Profile secondaryNameNodeProfile = this.service.createProfile(this.service.getDefaultVersion().getName(), "hadoop-" + this.name + "-secondary-namenode");
        secondaryNameNodeProfile.setParents(new Profile[]{cluster});
        configs = new HashMap();
        configs.put("org.fusesource.fabric.hadoop", new HashMap());
        ((Map)configs.get("org.fusesource.fabric.hadoop")).put("secondaryNameNode", "true");
        secondaryNameNodeProfile.setConfigurations(configs);
        Profile dataNodeProfile = this.service.createProfile(this.service.getDefaultVersion().getName(), "hadoop-" + this.name + "-datanode");
        dataNodeProfile.setParents(new Profile[]{cluster});
        configs = new HashMap();
        configs.put("org.fusesource.fabric.hadoop", new HashMap());
        ((Map)configs.get("org.fusesource.fabric.hadoop")).put("dataNode", "true");
        dataNodeProfile.setConfigurations(configs);
        Profile jobTrackerProfile = this.service.createProfile(this.service.getDefaultVersion().getName(), "hadoop-" + this.name + "-job-tracker");
        jobTrackerProfile.setParents(new Profile[]{cluster});
        configs = new HashMap();
        configs.put("org.fusesource.fabric.hadoop", new HashMap());
        ((Map)configs.get("org.fusesource.fabric.hadoop")).put("jobTracker", "true");
        jobTrackerProfile.setConfigurations(configs);
        Profile taskTrackerProfile = this.service.createProfile(this.service.getDefaultVersion().getName(), "hadoop-" + this.name + "-task-tracker");
        taskTrackerProfile.setParents(new Profile[]{cluster});
        configs = new HashMap();
        configs.put("org.fusesource.fabric.hadoop", new HashMap());
        ((Map)configs.get("org.fusesource.fabric.hadoop")).put("taskTracker", "true");
        taskTrackerProfile.setConfigurations(configs);
        Profile insightProfile = this.service.createProfile(this.service.getDefaultVersion().getName(), "insight-hdfs-" + this.name);
        insightProfile.setParents(new Profile[]{this.service.getProfile(this.service.getDefaultVersion().getName(), "insight-hdfs")});
        configs = new HashMap();
        configs.put("org.fusesource.insight.elasticsearch-default", new HashMap());
        ((Map)configs.get("org.fusesource.insight.elasticsearch-default")).put("gateway.hdfs.uri", "hdfs://${zk:" + this.nameNode + "/ip}:9000");
        insightProfile.setConfigurations(configs);
        Container nameNodeContainer = this.findContainer(containers, this.nameNode);
        if (nameNodeContainer == null && this.createChildren) {
            nameNodeContainer = this.createChild(this.nameNode);
        }
        this.addProfile(nameNodeContainer, nameNodeProfile);
        if (this.secondaryNameNode != null) {
            Container secondaryNameNodeContainer = this.findContainer(containers, this.secondaryNameNode);
            if (secondaryNameNodeContainer == null && this.createChildren) {
                secondaryNameNodeContainer = this.createChild(this.secondaryNameNode);
            }
            this.addProfile(secondaryNameNodeContainer, secondaryNameNodeProfile);
        }
        for (String n : this.dataNodes) {
            cont = this.findContainer(containers, n);
            if (cont == null) {
                cont = this.createChild(n);
            }
            this.addProfile(cont, dataNodeProfile);
        }
        if (this.jobTracker != null) {
            Container jobTrackerContainer = this.findContainer(containers, this.jobTracker);
            if (jobTrackerContainer == null && this.createChildren) {
                jobTrackerContainer = this.createChild(this.jobTracker);
            }
            this.addProfile(jobTrackerContainer, jobTrackerProfile);
        }
        for (String n : this.taskTrackers) {
            cont = this.findContainer(containers, n);
            if (cont == null) {
                cont = this.createChild(n);
            }
            this.addProfile(cont, taskTrackerProfile);
        }
        return null;
    }

    private Container createChild(String name) throws URISyntaxException {
        CreateContainerBasicOptions options = ((CreateContainerChildOptions)CreateContainerOptionsBuilder.child().name(name)).parent(this.service.getCurrentContainer().getId());
        CreateContainerMetadata[] metadatas = this.service.createContainers((CreateContainerOptions)options);
        Container container = metadatas[0].getContainer();
        return container;
    }

    private void addProfile(Container container, Profile profile) {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        for (Profile p : container.getProfiles()) {
            if (this.isAncestor(p, profile)) continue;
            profiles.add(p);
        }
        profiles.add(profile);
        container.setProfiles(profiles.toArray(new Profile[profiles.size()]));
    }

    private boolean isAncestor(Profile parent, Profile child) {
        if (child.getId().equals(parent.getId())) {
            return true;
        }
        for (Profile p : child.getParents()) {
            if (!this.isAncestor(parent, p)) continue;
            return true;
        }
        return false;
    }

    private Container findContainer(Container[] containers, String name) {
        for (Container cont : containers) {
            if (!name.equals(cont.getId())) continue;
            return cont;
        }
        return null;
    }
}

