/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.build.Project;
import aQute.bnd.maven.Maven;
import aQute.bnd.service.BndListener;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.service.action.Action;
import aQute.lib.deployer.FileRepo;
import aQute.lib.io.IO;
import aQute.lib.osgi.Processor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.naming.TimeLimitExceededException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Workspace
extends Processor {
    public static final String BUILDFILE = "build.bnd";
    public static final String CNFDIR = "cnf";
    public static final String BNDDIR = "bnd";
    public static final String CACHEDIR = "cache";
    static Map<File, WeakReference<Workspace>> cache = Workspace.newHashMap();
    final Map<String, Project> models = Workspace.newHashMap();
    final Map<String, Action> commands = Workspace.newMap();
    final CachedFileRepo cachedRepo;
    final File buildDir;
    final Maven maven = new Maven();

    public static Project getProject(File projectDir) throws Exception {
        projectDir = projectDir.getAbsoluteFile();
        assert (projectDir.isDirectory());
        Workspace ws = Workspace.getWorkspace(projectDir.getParentFile());
        return ws.getProject(projectDir.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Workspace getWorkspace(File parent) throws Exception {
        File workspaceDir = parent.getAbsoluteFile();
        while (workspaceDir.isDirectory()) {
            File test = new File(workspaceDir, CNFDIR);
            if (!test.exists()) {
                test = new File(workspaceDir, BNDDIR);
            }
            if (test.isDirectory()) break;
            if (test.isFile()) {
                String redirect = IO.collect(test).trim();
                workspaceDir = test = Workspace.getFile(test.getParentFile(), redirect).getAbsoluteFile();
            }
            if (test.exists()) continue;
            throw new IllegalArgumentException("No Workspace found from: " + parent);
        }
        Map<File, WeakReference<Workspace>> map = cache;
        synchronized (map) {
            Workspace ws;
            WeakReference<Workspace> wsr = cache.get(workspaceDir);
            if (wsr == null || (ws = (Workspace)wsr.get()) == null) {
                ws = new Workspace(workspaceDir);
                cache.put(workspaceDir, new WeakReference<Workspace>(ws));
            }
            return ws;
        }
    }

    public Workspace(File dir) throws Exception {
        File extDir;
        File[] extensions;
        dir = dir.getAbsoluteFile();
        dir.mkdirs();
        assert (dir.isDirectory());
        File buildDir = new File(dir, BNDDIR).getAbsoluteFile();
        if (!buildDir.isDirectory()) {
            buildDir = new File(dir, CNFDIR).getAbsoluteFile();
        }
        this.buildDir = buildDir;
        File buildFile = new File(buildDir, BUILDFILE).getAbsoluteFile();
        if (!buildFile.isFile()) {
            this.warning("No Build File in " + dir, new Object[0]);
        }
        if ((extensions = (extDir = new File(this.buildDir, "ext")).listFiles()) != null) {
            for (File extension : extensions) {
                if (!extension.getName().endsWith(".bnd")) continue;
                this.doIncludeFile(extension, true, this.getProperties());
            }
        }
        this.setProperties(buildFile, dir);
        this.cachedRepo = new CachedFileRepo();
        this.addBasicPlugin(this.cachedRepo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project getProject(String bsn) throws Exception {
        Map<String, Project> map = this.models;
        synchronized (map) {
            Project project = this.models.get(bsn);
            if (project != null) {
                return project;
            }
            File projectDir = this.getFile(bsn);
            project = new Project(this, projectDir);
            if (!project.isValid()) {
                return null;
            }
            this.models.put(bsn, project);
            return project;
        }
    }

    public boolean isPresent(String name) {
        return this.models.containsKey(name);
    }

    public Collection<Project> getCurrentProjects() {
        return this.models.values();
    }

    @Override
    public boolean refresh() {
        if (super.refresh()) {
            for (Project project : this.getCurrentProjects()) {
                project.propertiesChanged();
            }
            return true;
        }
        return false;
    }

    public String _workspace(String[] args) {
        return this.getBase().getAbsolutePath();
    }

    public void addCommand(String menu, Action action) {
        this.commands.put(menu, action);
    }

    public void removeCommand(String menu) {
        this.commands.remove(menu);
    }

    public void fillActions(Map<String, Action> all) {
        all.putAll(this.commands);
    }

    public Collection<Project> getAllProjects() throws Exception {
        ArrayList<Project> projects = new ArrayList<Project>();
        for (File file : this.getBase().listFiles()) {
            if (!new File(file, "bnd.bnd").isFile()) continue;
            projects.add(Workspace.getProject(file));
        }
        return projects;
    }

    public void changedFile(File f) {
        List<BndListener> listeners = this.getPlugins(BndListener.class);
        for (BndListener l : listeners) {
            try {
                l.changed(f);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void copy(InputStream in, OutputStream out) throws Exception {
        byte[] data = new byte[10000];
        int size = in.read(data);
        while (size > 0) {
            out.write(data, 0, size);
            size = in.read(data);
        }
    }

    public List<RepositoryPlugin> getRepositories() {
        return this.getPlugins(RepositoryPlugin.class);
    }

    public static Workspace getWorkspace(String path) throws Exception {
        File file = IO.getFile(new File(""), path);
        return Workspace.getWorkspace(file);
    }

    public Maven getMaven() {
        return this.maven;
    }

    class CachedFileRepo
    extends FileRepo {
        final Lock lock;
        boolean inited;

        CachedFileRepo() {
            super(Workspace.CACHEDIR, Processor.getFile(Workspace.this.buildDir, Workspace.CACHEDIR), false);
            this.lock = new ReentrantLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void init() throws Exception {
            if (!this.lock.tryLock(50L, TimeUnit.SECONDS)) {
                throw new TimeLimitExceededException("Cached File Repo is locked and can't acquire it");
            }
            try {
                if (!this.inited) {
                    this.inited = true;
                    this.root.mkdirs();
                    if (!this.root.isDirectory()) {
                        throw new IllegalArgumentException("Cannot create cache dir " + this.root);
                    }
                    InputStream in = this.getClass().getResourceAsStream("/embedded-repo.jar");
                    if (in != null) {
                        this.unzip(in, this.root);
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unzip(InputStream in, File dir) throws Exception {
            try {
                JarInputStream jin = new JarInputStream(in);
                JarEntry jentry = jin.getNextJarEntry();
                while (jentry != null) {
                    File dest;
                    if (!(jentry.isDirectory() || (dest = Processor.getFile(dir, jentry.getName())).isFile() && dest.lastModified() >= jentry.getTime() && jentry.getTime() != 0L)) {
                        dest.getParentFile().mkdirs();
                        FileOutputStream out = new FileOutputStream(dest);
                        try {
                            Workspace.this.copy(jin, out);
                        }
                        finally {
                            out.close();
                        }
                    }
                    jentry = jin.getNextJarEntry();
                }
            }
            finally {
                in.close();
            }
        }
    }
}

