/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.recipe;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jclouds.karaf.recipe.RecipeManager;
import org.jclouds.karaf.recipe.RecipeProvider;
import org.jclouds.karaf.recipe.RecipeProviders;
import org.jclouds.scriptbuilder.domain.Statement;

public class RecipeManagerImpl
implements RecipeManager {
    Map<String, RecipeProvider> recipeProviderMap = Maps.newConcurrentMap();

    @Override
    public Statement createStatement(String coords, String group) throws NoSuchElementException {
        if (coords != null && coords.contains("/")) {
            String id = coords.substring(0, coords.indexOf("/"));
            String recipe = coords.substring(coords.indexOf("/") + 1);
            if (this.recipeProviderMap.containsKey(id)) {
                RecipeProvider provider = this.recipeProviderMap.get(id);
                return provider.createStatement(recipe, group);
            }
            RecipeProvider provider = RecipeProviders.withId(id);
            return provider.createStatement(recipe, group);
        }
        throw new IllegalArgumentException("Recipe coords should have the follwing format <recipe provider>/<recipe>");
    }

    @Override
    public void bind(RecipeProvider provider) {
        this.recipeProviderMap.put(provider.getId(), provider);
    }

    @Override
    public void unibind(RecipeProvider provider) {
        this.recipeProviderMap.remove(provider.getId());
    }
}

