/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.services.internal;

import java.util.Hashtable;
import org.jclouds.karaf.services.internal.BlobStoreServiceFactory;
import org.jclouds.karaf.services.internal.ComputeServiceFactory;
import org.jclouds.osgi.ApiListener;
import org.jclouds.osgi.ProviderListener;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedServiceFactory;

public class Activator
implements BundleActivator {
    ServiceRegistration computeFactoryRegistration;
    ServiceRegistration blobStoreFactoryRegistration;
    ComputeServiceFactory computeFactory;
    BlobStoreServiceFactory blobStoreFactory;

    public void start(BundleContext context) throws Exception {
        this.registerComputeServiceFactory(context);
        this.registerBlobstoreServiceFactory(context);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.computeFactoryRegistration != null) {
            this.computeFactoryRegistration.unregister();
        }
        if (this.blobStoreFactoryRegistration != null) {
            this.blobStoreFactoryRegistration.unregister();
        }
    }

    private void registerComputeServiceFactory(BundleContext context) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("service.pid", "org.jclouds.compute");
        this.computeFactory = new ComputeServiceFactory(context);
        this.computeFactoryRegistration = context.registerService(new String[]{ManagedServiceFactory.class.getName(), ProviderListener.class.getName(), ApiListener.class.getName()}, (Object)this.computeFactory, properties);
    }

    private void registerBlobstoreServiceFactory(BundleContext context) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("service.pid", "org.jclouds.blobstore");
        this.blobStoreFactory = new BlobStoreServiceFactory(context);
        this.blobStoreFactoryRegistration = context.registerService(new String[]{ManagedServiceFactory.class.getName(), ProviderListener.class.getName(), ApiListener.class.getName()}, (Object)this.blobStoreFactory, properties);
    }
}

