/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.binders;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindS3UploadPolicyAndSignature
implements Binder {
    private final FormSigner signer;

    @Inject
    BindS3UploadPolicyAndSignature(FormSigner signer) {
        this.signer = signer;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        String encodedJson = CryptoStreams.base64((byte[])Preconditions.checkNotNull((Object)input, (Object)"json").toString().getBytes(Charsets.UTF_8));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)"Storage.S3.UploadPolicy", (Object)encodedJson);
        String signature = this.signer.sign(encodedJson);
        builder.put((Object)"Storage.S3.UploadPolicySignature", (Object)signature);
        return (R)request.toBuilder().replaceFormParams((Multimap)builder.build()).build();
    }
}

