/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.strategy;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.ec2.EC2AsyncClient;
import org.jclouds.ec2.domain.Image;
import org.jclouds.ec2.options.DescribeImagesOptions;
import org.jclouds.logging.Logger;

@Singleton
public class DescribeImagesParallel
implements Function<Iterable<Map.Entry<String, DescribeImagesOptions>>, Iterable<? extends Image>> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final EC2AsyncClient async;
    final ExecutorService executor;

    @Inject
    public DescribeImagesParallel(EC2AsyncClient async, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.async = async;
        this.executor = executor;
    }

    public Iterable<? extends Image> apply(Iterable<Map.Entry<String, DescribeImagesOptions>> queries) {
        return Iterables.concat((Iterable)FutureIterables.transformParallel(queries, (Function)new Function<Map.Entry<String, DescribeImagesOptions>, Future<? extends Set<? extends Image>>>(){

            public Future<Set<? extends Image>> apply(Map.Entry<String, DescribeImagesOptions> from) {
                return DescribeImagesParallel.this.async.getAMIServices().describeImagesInRegion(from.getKey(), from.getValue());
            }
        }, (ExecutorService)this.executor, null, (Logger)this.logger, (String)"amis"));
    }
}

