/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.util;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Comparator;
import java.util.Map;

public class TagFilterBuilder
extends ImmutableMultimap.Builder<String, String> {
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String RESOURCE_ID = "resource-id";
    private static final String RESOURCE_TYPE = "resource-type";

    public TagFilterBuilder key(String key) {
        return this.put(KEY, key);
    }

    public TagFilterBuilder keys(String ... keys) {
        return this.putAll(KEY, keys);
    }

    public TagFilterBuilder keys(Iterable<String> keys) {
        return this.putAll(KEY, keys);
    }

    public TagFilterBuilder anyKey() {
        return this.putAll(KEY, (Iterable<? extends String>)ImmutableSet.of());
    }

    public TagFilterBuilder value(String value) {
        return this.put(VALUE, value);
    }

    public TagFilterBuilder values(String ... values) {
        return this.putAll(VALUE, (Iterable<? extends String>)ImmutableSet.copyOf((Object[])values));
    }

    public TagFilterBuilder values(Iterable<String> values) {
        return this.putAll(VALUE, (Iterable<? extends String>)ImmutableSet.copyOf(values));
    }

    public TagFilterBuilder anyValue() {
        return this.putAll(VALUE, (Iterable<? extends String>)ImmutableSet.of());
    }

    public TagFilterBuilder resourceId(String resourceId) {
        return this.put(RESOURCE_ID, resourceId);
    }

    public TagFilterBuilder resourceIds(String ... resourceIds) {
        return this.putAll(RESOURCE_ID, resourceIds);
    }

    public TagFilterBuilder resourceIds(Iterable<String> resourceIds) {
        return this.putAll(RESOURCE_ID, resourceIds);
    }

    public TagFilterBuilder anyResourceId() {
        return this.putAll(RESOURCE_TYPE, (Iterable<? extends String>)ImmutableSet.of());
    }

    public TagFilterBuilder resourceType(String resourceType) {
        return this.put(RESOURCE_TYPE, resourceType);
    }

    public TagFilterBuilder resourceTypes(String ... resourceTypes) {
        return this.putAll(RESOURCE_TYPE, resourceTypes);
    }

    public TagFilterBuilder resourceTypes(Iterable<String> resourceTypes) {
        return this.putAll(RESOURCE_TYPE, resourceTypes);
    }

    public TagFilterBuilder anyResourceType() {
        return this.putAll(RESOURCE_TYPE, (Iterable<? extends String>)ImmutableSet.of());
    }

    public TagFilterBuilder customerGateway() {
        return this.put(RESOURCE_TYPE, "customer-gateway");
    }

    public TagFilterBuilder dhcpOptions() {
        return this.put(RESOURCE_TYPE, "dhcp-options");
    }

    public TagFilterBuilder image() {
        return this.put(RESOURCE_TYPE, "image");
    }

    public TagFilterBuilder instance() {
        return this.put(RESOURCE_TYPE, "instance");
    }

    public TagFilterBuilder internetGateway() {
        return this.put(RESOURCE_TYPE, "internet-gateway");
    }

    public TagFilterBuilder networkAcl() {
        return this.put(RESOURCE_TYPE, "network-acl");
    }

    public TagFilterBuilder reservedInstance() {
        return this.put(RESOURCE_TYPE, "reserved-instances");
    }

    public TagFilterBuilder routeTable() {
        return this.put(RESOURCE_TYPE, "route-table");
    }

    public TagFilterBuilder securityGroup() {
        return this.put(RESOURCE_TYPE, "security-group");
    }

    public TagFilterBuilder snapshot() {
        return this.put(RESOURCE_TYPE, "snapshot");
    }

    public TagFilterBuilder instancesRequest() {
        return this.put(RESOURCE_TYPE, "spot-instances-request");
    }

    public TagFilterBuilder subnet() {
        return this.put(RESOURCE_TYPE, "subnet");
    }

    public TagFilterBuilder volume() {
        return this.put(RESOURCE_TYPE, "volume");
    }

    public TagFilterBuilder vpc() {
        return this.put(RESOURCE_TYPE, "vpc");
    }

    public TagFilterBuilder vpnConnection() {
        return this.put(RESOURCE_TYPE, "vpn-connection");
    }

    public TagFilterBuilder vpnGateway() {
        return this.put(RESOURCE_TYPE, "vpn-gateway");
    }

    public TagFilterBuilder put(String key, String value) {
        return (TagFilterBuilder)((Object)TagFilterBuilder.class.cast(super.put((Object)key, (Object)value)));
    }

    public TagFilterBuilder put(Map.Entry<? extends String, ? extends String> entry) {
        return (TagFilterBuilder)((Object)TagFilterBuilder.class.cast(super.put(entry)));
    }

    public TagFilterBuilder putAll(String key, Iterable<? extends String> values) {
        return (TagFilterBuilder)((Object)TagFilterBuilder.class.cast(super.putAll((Object)key, values)));
    }

    public TagFilterBuilder putAll(String key, String ... values) {
        return (TagFilterBuilder)((Object)TagFilterBuilder.class.cast(super.putAll((Object)key, (Object[])values)));
    }

    public TagFilterBuilder putAll(Multimap<? extends String, ? extends String> multimap) {
        return (TagFilterBuilder)((Object)TagFilterBuilder.class.cast(super.putAll(multimap)));
    }

    @Beta
    public TagFilterBuilder orderKeysBy(Comparator<? super String> keyComparator) {
        return (TagFilterBuilder)((Object)TagFilterBuilder.class.cast(super.orderKeysBy(keyComparator)));
    }

    @Beta
    public TagFilterBuilder orderValuesBy(Comparator<? super String> valueComparator) {
        return (TagFilterBuilder)((Object)TagFilterBuilder.class.cast(super.orderValuesBy(valueComparator)));
    }
}

