/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import org.jclouds.ec2.domain.Tag;
import org.jclouds.ec2.xml.TagHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DescribeTagsResponseHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<FluentIterable<Tag>> {
    private final TagHandler tagHander;
    private StringBuilder currentText = new StringBuilder();
    private ImmutableSet.Builder<Tag> tags = ImmutableSet.builder();
    private boolean inTags;

    @Inject
    public DescribeTagsResponseHandler(TagHandler tagHander) {
        this.tagHander = tagHander;
    }

    public FluentIterable<Tag> getResult() {
        return FluentIterable.from((Iterable)this.tags.build());
    }

    public void startElement(String url, String name, String qName, Attributes attributes) throws SAXException {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"tagSet")) {
            this.inTags = true;
        }
        if (this.inTags) {
            this.tagHander.startElement(url, name, qName, attributes);
        }
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"tagSet")) {
            this.inTags = false;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"item")) {
            this.tags.add((Object)this.tagHander.getResult());
        } else if (this.inTags) {
            this.tagHander.endElement(uri, name, qName);
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inTags) {
            this.tagHander.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

