/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import javax.inject.Inject;
import org.jclouds.date.DateCodec;
import org.jclouds.date.DateCodecFactory;
import org.jclouds.ec2.domain.PasswordData;
import org.jclouds.http.functions.ParseSax;

public class GetPasswordDataResponseHandler
extends ParseSax.HandlerWithResult<PasswordData> {
    protected final DateCodec dateCodec;
    private StringBuilder currentText = new StringBuilder();
    private PasswordData.Builder builder = PasswordData.builder();

    @Inject
    protected GetPasswordDataResponseHandler(DateCodecFactory dateCodecFactory) {
        this.dateCodec = dateCodecFactory.iso8601();
    }

    public PasswordData getResult() {
        return this.builder.build();
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("instanceId")) {
            this.builder.instanceId(this.currentText.toString().trim());
        } else if (qName.equals("timestamp")) {
            this.builder.timestamp(this.dateCodec.toDate(this.currentText.toString().trim()));
        } else if (qName.equals("passwordData")) {
            this.builder.passwordData(this.currentText.toString().trim());
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

