/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.service;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.karaf.admin.management.AdminServiceMBean;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.ContainerProvider;
import org.fusesource.fabric.api.CreateContainerChildMetadata;
import org.fusesource.fabric.api.CreateContainerChildOptions;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.service.ContainerTemplate;
import org.fusesource.fabric.service.FabricServiceImpl;
import org.fusesource.fabric.utils.AuthenticationUtils;
import org.fusesource.fabric.utils.Ports;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.fusesource.fabric.zookeeper.ZkDefs;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.fusesource.fabric.zookeeper.utils.ZooKeeperUtils;

public class ChildContainerProvider
implements ContainerProvider<CreateContainerChildOptions, CreateContainerChildMetadata> {
    final FabricServiceImpl service;
    Set<Integer> usedPorts = new LinkedHashSet<Integer>();

    public ChildContainerProvider(FabricServiceImpl service) {
        this.service = service;
    }

    @Override
    public Set<CreateContainerChildMetadata> create(final CreateContainerChildOptions options) throws Exception {
        final LinkedHashSet<CreateContainerChildMetadata> result = new LinkedHashSet<CreateContainerChildMetadata>();
        final String parentName = options.getParent();
        final Container parent = this.service.getContainer(parentName);
        ContainerTemplate containerTemplate = this.service.getContainerTemplate(parent, options.getJmxUser(), options.getJmxPassword());
        containerTemplate.execute(new ContainerTemplate.AdminServiceCallback<Object>(){

            @Override
            public Object doWithAdminService(AdminServiceMBean adminService) throws Exception {
                StringBuilder jvmOptsBuilder = new StringBuilder();
                jvmOptsBuilder.append("-server -Dcom.sun.management.jmxremote").append(options.getZookeeperUrl() != null ? " -Dzookeeper.url=\"" + options.getZookeeperUrl() + "\"" : "").append(options.getZookeeperPassword() != null ? " -Dzookeeper.password=\"" + options.getZookeeperPassword() + "\"" : "");
                if (options.getJvmOpts() == null || !options.getJvmOpts().contains("-Xmx")) {
                    jvmOptsBuilder.append(" -Xmx512m");
                }
                if (options.isEnsembleServer()) {
                    jvmOptsBuilder.append(" ").append(" -Densemble.auto.start=true");
                }
                if (options.getJvmOpts() != null && !options.getJvmOpts().isEmpty()) {
                    jvmOptsBuilder.append(" ").append(options.getJvmOpts());
                }
                if (options.getJvmOpts() != null && !options.getJvmOpts().contains("-XX:+UnlockDiagnosticVMOptions -XX:+UnsyncloadClass")) {
                    jvmOptsBuilder.append(" -XX:+UnlockDiagnosticVMOptions -XX:+UnsyncloadClass");
                }
                Profile defaultProfile = ChildContainerProvider.this.service.getProfile(parent.getVersion().getName(), "default");
                String featuresUrls = ChildContainerProvider.listAsString(defaultProfile.getRepositories());
                String features = ChildContainerProvider.listAsString(defaultProfile.getFeatures());
                String originalName = options.getName();
                ChildContainerProvider.this.usedPorts.addAll(ChildContainerProvider.this.getContainerUsedPorts(parent));
                for (int i = 1; i <= options.getNumber(); ++i) {
                    String containerName = options.getNumber() > 1 ? originalName + i : originalName;
                    CreateContainerChildMetadata metadata = new CreateContainerChildMetadata();
                    metadata.setCreateOptions(options);
                    metadata.setContainerName(containerName);
                    int minimumPort = parent.getMinimumPort();
                    int maximumPort = parent.getMaximumPort();
                    ZooKeeperUtils.set((IZKClient)ChildContainerProvider.this.service.getZooKeeper(), (String)ZkPath.CONTAINER_PORT_MIN.getPath(new String[]{containerName}), (String)String.valueOf(minimumPort));
                    ZooKeeperUtils.set((IZKClient)ChildContainerProvider.this.service.getZooKeeper(), (String)ZkPath.CONTAINER_PORT_MAX.getPath(new String[]{containerName}), (String)String.valueOf(maximumPort));
                    ChildContainerProvider.this.inheritAddresses(ChildContainerProvider.this.service.getZooKeeper(), parentName, containerName, options);
                    int sshPort = Ports.mapPortToRange(8101 + i, minimumPort, maximumPort);
                    while (ChildContainerProvider.this.usedPorts.contains(sshPort)) {
                        ++sshPort;
                    }
                    ChildContainerProvider.this.usedPorts.add(sshPort);
                    int rmiServerPort = Ports.mapPortToRange(44444 + i, minimumPort, maximumPort);
                    while (ChildContainerProvider.this.usedPorts.contains(rmiServerPort)) {
                        ++rmiServerPort;
                    }
                    ChildContainerProvider.this.usedPorts.add(rmiServerPort);
                    int rmiRegistryPort = Ports.mapPortToRange(1099 + i, minimumPort, maximumPort);
                    while (ChildContainerProvider.this.usedPorts.contains(rmiRegistryPort)) {
                        ++rmiRegistryPort;
                    }
                    ChildContainerProvider.this.usedPorts.add(rmiRegistryPort);
                    try {
                        adminService.createInstance(containerName, sshPort, rmiServerPort, rmiRegistryPort, null, jvmOptsBuilder.toString(), features, featuresUrls);
                        adminService.startInstance(containerName, null);
                    }
                    catch (Throwable t) {
                        metadata.setFailure(t);
                    }
                    result.add(metadata);
                }
                return null;
            }
        });
        return result;
    }

    @Override
    public void start(final Container container) {
        this.getContainerTemplateForChild(container).execute(new ContainerTemplate.AdminServiceCallback<Object>(){

            @Override
            public Object doWithAdminService(AdminServiceMBean adminService) throws Exception {
                adminService.startInstance(container.getId(), null);
                return null;
            }
        });
    }

    @Override
    public void stop(final Container container) {
        this.getContainerTemplateForChild(container).execute(new ContainerTemplate.AdminServiceCallback<Object>(){

            @Override
            public Object doWithAdminService(AdminServiceMBean adminService) throws Exception {
                adminService.stopInstance(container.getId());
                return null;
            }
        });
    }

    @Override
    public void destroy(final Container container) {
        this.getContainerTemplateForChild(container).execute(new ContainerTemplate.AdminServiceCallback<Object>(){

            @Override
            public Object doWithAdminService(AdminServiceMBean adminService) throws Exception {
                block2: {
                    try {
                        adminService.stopInstance(container.getId());
                    }
                    catch (Exception e) {
                        if (!container.isAlive()) break block2;
                        throw e;
                    }
                }
                adminService.destroyInstance(container.getId());
                return null;
            }
        });
    }

    protected ContainerTemplate getContainerTemplateForChild(Container container) {
        CreateContainerChildOptions options = (CreateContainerChildOptions)container.getMetadata().getCreateOptions();
        String username = AuthenticationUtils.retrieveJaasUser();
        String password = AuthenticationUtils.retrieveJaasPassword();
        if (username != null && password != null) {
            options.setJmxPassword(password);
            options.setJmxUser(username);
        }
        return new ContainerTemplate(container.getParent(), options.getJmxUser(), options.getJmxPassword(), false);
    }

    private Set<Integer> getContainerUsedPorts(Container container) {
        LinkedHashSet<Integer> usedPorts = new LinkedHashSet<Integer>();
        usedPorts.add(this.getSshPort(container));
        usedPorts.addAll(this.getRmiPorts(container));
        if (container.getChildren() != null) {
            for (Container child : container.getChildren()) {
                usedPorts.addAll(this.getContainerUsedPorts(child));
            }
        }
        return usedPorts;
    }

    private int getSshPort(Container container) {
        String sshUrl = container.getSshUrl();
        int sshPort = 0;
        if (sshUrl != null) {
            sshPort = Ports.extractPort(sshUrl);
        }
        return sshPort;
    }

    private Set<Integer> getRmiPorts(Container container) {
        LinkedHashSet<Integer> rmiPorts = new LinkedHashSet<Integer>();
        String jmxUrl = container.getJmxUrl();
        String address = container.getIp();
        if (jmxUrl != null && address != null) {
            Pattern pattern = Pattern.compile(address + ":\\d{1,5}");
            Matcher mather = pattern.matcher(jmxUrl);
            while (mather.find()) {
                String socketAddress = mather.group();
                rmiPorts.add(Ports.extractPort(socketAddress));
            }
        }
        return rmiPorts;
    }

    private void inheritAddresses(IZKClient zooKeeper, String parent, String name, CreateContainerChildOptions options) throws KeeperException, InterruptedException {
        for (String resolver : ZkDefs.VALID_RESOLVERS) {
            zooKeeper.createOrSetWithParents(ZkPath.CONTAINER_ADDRESS.getPath(new String[]{name, resolver}), "${zk:" + parent + "/" + resolver + "}", CreateMode.PERSISTENT);
        }
        if (options.getResolver() != null) {
            zooKeeper.createOrSetWithParents(ZkPath.CONTAINER_RESOLVER.getPath(new String[]{name}), options.getResolver(), CreateMode.PERSISTENT);
        } else {
            zooKeeper.createOrSetWithParents(ZkPath.CONTAINER_RESOLVER.getPath(new String[]{name}), "${zk:" + parent + "/resolver}", CreateMode.PERSISTENT);
        }
        zooKeeper.createOrSetWithParents(ZkPath.CONTAINER_RESOLVER.getPath(new String[]{name}), "${zk:" + parent + "/resolver}", CreateMode.PERSISTENT);
        zooKeeper.createOrSetWithParents(ZkPath.CONTAINER_IP.getPath(new String[]{name}), "${zk:" + name + "/resolver}", CreateMode.PERSISTENT);
    }

    private static String listAsString(List<String> value) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (value != null) {
            for (String el : value) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(el);
            }
        }
        return sb.toString();
    }
}

