/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.info;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.support.nodes.NodeOperationResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.http.HttpInfo;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.monitor.network.NetworkInfo;
import org.elasticsearch.monitor.os.OsInfo;
import org.elasticsearch.monitor.process.ProcessInfo;
import org.elasticsearch.threadpool.ThreadPoolInfo;
import org.elasticsearch.transport.TransportInfo;

public class NodeInfo
extends NodeOperationResponse {
    @Nullable
    private ImmutableMap<String, String> serviceAttributes;
    @Nullable
    private String hostname;
    @Nullable
    private Settings settings;
    @Nullable
    private OsInfo os;
    @Nullable
    private ProcessInfo process;
    @Nullable
    private JvmInfo jvm;
    @Nullable
    private ThreadPoolInfo threadPool;
    @Nullable
    private NetworkInfo network;
    @Nullable
    private TransportInfo transport;
    @Nullable
    private HttpInfo http;

    NodeInfo() {
    }

    public NodeInfo(@Nullable String hostname, DiscoveryNode node, @Nullable ImmutableMap<String, String> serviceAttributes, @Nullable Settings settings, @Nullable OsInfo os, @Nullable ProcessInfo process, @Nullable JvmInfo jvm, @Nullable ThreadPoolInfo threadPool, @Nullable NetworkInfo network, @Nullable TransportInfo transport, @Nullable HttpInfo http) {
        super(node);
        this.hostname = hostname;
        this.serviceAttributes = serviceAttributes;
        this.settings = settings;
        this.os = os;
        this.process = process;
        this.jvm = jvm;
        this.threadPool = threadPool;
        this.network = network;
        this.transport = transport;
        this.http = http;
    }

    @Nullable
    public String hostname() {
        return this.hostname;
    }

    @Nullable
    public String getHostname() {
        return this.hostname();
    }

    @Nullable
    public ImmutableMap<String, String> serviceAttributes() {
        return this.serviceAttributes;
    }

    @Nullable
    public ImmutableMap<String, String> getServiceAttributes() {
        return this.serviceAttributes();
    }

    @Nullable
    public Settings settings() {
        return this.settings;
    }

    @Nullable
    public Settings getSettings() {
        return this.settings();
    }

    @Nullable
    public OsInfo os() {
        return this.os;
    }

    @Nullable
    public OsInfo getOs() {
        return this.os();
    }

    @Nullable
    public ProcessInfo process() {
        return this.process;
    }

    @Nullable
    public ProcessInfo getProcess() {
        return this.process();
    }

    @Nullable
    public JvmInfo jvm() {
        return this.jvm;
    }

    @Nullable
    public JvmInfo getJvm() {
        return this.jvm();
    }

    @Nullable
    public ThreadPoolInfo threadPool() {
        return this.threadPool;
    }

    @Nullable
    public ThreadPoolInfo getThreadPool() {
        return this.threadPool();
    }

    @Nullable
    public NetworkInfo network() {
        return this.network;
    }

    @Nullable
    public NetworkInfo getNetwork() {
        return this.network();
    }

    @Nullable
    public TransportInfo transport() {
        return this.transport;
    }

    @Nullable
    public TransportInfo getTransport() {
        return this.transport();
    }

    @Nullable
    public HttpInfo http() {
        return this.http;
    }

    @Nullable
    public HttpInfo getHttp() {
        return this.http();
    }

    public static NodeInfo readNodeInfo(StreamInput in) throws IOException {
        NodeInfo nodeInfo = new NodeInfo();
        nodeInfo.readFrom(in);
        return nodeInfo;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        if (in.readBoolean()) {
            this.hostname = in.readUTF();
        }
        if (in.readBoolean()) {
            ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
            int size = in.readVInt();
            for (int i = 0; i < size; ++i) {
                builder.put(in.readUTF(), in.readUTF());
            }
            this.serviceAttributes = builder.build();
        }
        if (in.readBoolean()) {
            this.settings = ImmutableSettings.readSettingsFromStream(in);
        }
        if (in.readBoolean()) {
            this.os = OsInfo.readOsInfo(in);
        }
        if (in.readBoolean()) {
            this.process = ProcessInfo.readProcessInfo(in);
        }
        if (in.readBoolean()) {
            this.jvm = JvmInfo.readJvmInfo(in);
        }
        if (in.readBoolean()) {
            this.threadPool = ThreadPoolInfo.readThreadPoolInfo(in);
        }
        if (in.readBoolean()) {
            this.network = NetworkInfo.readNetworkInfo(in);
        }
        if (in.readBoolean()) {
            this.transport = TransportInfo.readTransportInfo(in);
        }
        if (in.readBoolean()) {
            this.http = HttpInfo.readHttpInfo(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.hostname == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.hostname);
        }
        if (this.serviceAttributes() == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.serviceAttributes.size());
            for (Map.Entry entry : this.serviceAttributes.entrySet()) {
                out.writeUTF((String)entry.getKey());
                out.writeUTF((String)entry.getValue());
            }
        }
        if (this.settings == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            ImmutableSettings.writeSettingsToStream(this.settings, out);
        }
        if (this.os == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.os.writeTo(out);
        }
        if (this.process == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.process.writeTo(out);
        }
        if (this.jvm == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.jvm.writeTo(out);
        }
        if (this.threadPool == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.threadPool.writeTo(out);
        }
        if (this.network == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.network.writeTo(out);
        }
        if (this.transport == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.transport.writeTo(out);
        }
        if (this.http == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.http.writeTo(out);
        }
    }
}

