/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.support.BaseRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Nullable;

public class MultiGetRequestBuilder
extends BaseRequestBuilder<MultiGetRequest, MultiGetResponse> {
    public MultiGetRequestBuilder(Client client) {
        super(client, new MultiGetRequest());
    }

    public MultiGetRequestBuilder add(String index, @Nullable String type, String id) {
        ((MultiGetRequest)this.request).add(index, type, id);
        return this;
    }

    public MultiGetRequestBuilder add(String index, @Nullable String type, Iterable<String> ids) {
        for (String id : ids) {
            ((MultiGetRequest)this.request).add(index, type, id);
        }
        return this;
    }

    public MultiGetRequestBuilder add(String index, @Nullable String type, String ... ids) {
        for (String id : ids) {
            ((MultiGetRequest)this.request).add(index, type, id);
        }
        return this;
    }

    public MultiGetRequestBuilder add(MultiGetRequest.Item item) {
        ((MultiGetRequest)this.request).add(item);
        return this;
    }

    public MultiGetRequestBuilder setPreference(String preference) {
        ((MultiGetRequest)this.request).preference(preference);
        return this;
    }

    public MultiGetRequestBuilder setRefresh(boolean refresh) {
        ((MultiGetRequest)this.request).refresh(refresh);
        return this;
    }

    public MultiGetRequestBuilder setRealtime(Boolean realtime) {
        ((MultiGetRequest)this.request).realtime(realtime);
        return this;
    }

    public MultiGetRequestBuilder setListenerThreaded(boolean threadedListener) {
        ((MultiGetRequest)this.request).listenerThreaded(threadedListener);
        return this;
    }

    @Override
    protected void doExecute(ActionListener<MultiGetResponse> listener) {
        this.client.multiGet((MultiGetRequest)this.request, listener);
    }
}

