/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;

public class MultiSearchRequest
implements ActionRequest {
    private List<SearchRequest> requests = Lists.newArrayList();
    private boolean listenerThreaded = false;

    public MultiSearchRequest add(SearchRequestBuilder request) {
        this.requests.add(request.request());
        return this;
    }

    public MultiSearchRequest add(SearchRequest request) {
        this.requests.add(request);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiSearchRequest add(byte[] data, int from, int length, boolean contentUnsafe, @Nullable String[] indices, @Nullable String[] types) throws Exception {
        int nextMarker;
        XContent xContent = XContentFactory.xContent(data, from, length);
        byte marker = xContent.streamSeparator();
        while ((nextMarker = this.findNextMarker(marker, from, data, length)) != -1) {
            if (nextMarker == 0) {
                from = nextMarker + 1;
                continue;
            }
            SearchRequest searchRequest = new SearchRequest(indices);
            if (types != null && types.length > 0) {
                searchRequest.types(types);
            }
            if (nextMarker - from > 0) {
                XContentParser parser = xContent.createParser(data, from, nextMarker - from);
                try {
                    XContentParser.Token token = parser.nextToken();
                    if (token != null) {
                        assert (token == XContentParser.Token.START_OBJECT);
                        String currentFieldName = null;
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (!token.isValue()) continue;
                            if ("index".equals(currentFieldName) || "indices".equals(currentFieldName)) {
                                searchRequest.indices(Strings.splitStringByCommaToArray(parser.text()));
                                continue;
                            }
                            if ("type".equals(currentFieldName) || "types".equals(currentFieldName)) {
                                searchRequest.types(Strings.splitStringByCommaToArray(parser.text()));
                                continue;
                            }
                            if ("search_type".equals(currentFieldName) || "searchType".equals(currentFieldName)) {
                                searchRequest.searchType(parser.text());
                                continue;
                            }
                            if ("preference".equals(currentFieldName)) {
                                searchRequest.preference(parser.text());
                                continue;
                            }
                            if ("routing".equals(currentFieldName)) {
                                searchRequest.routing(parser.text());
                                continue;
                            }
                            if (!"query_hint".equals(currentFieldName) && !"queryHint".equals(currentFieldName)) continue;
                            searchRequest.queryHint(parser.text());
                        }
                    }
                }
                finally {
                    parser.close();
                }
            }
            if ((nextMarker = this.findNextMarker(marker, from = nextMarker + 1, data, length)) == -1) break;
            searchRequest.source(data, from, nextMarker - from, contentUnsafe);
            from = nextMarker + 1;
            this.add(searchRequest);
        }
        return this;
    }

    private int findNextMarker(byte marker, int from, byte[] data, int length) {
        for (int i = from; i < length; ++i) {
            if (data[i] != marker) continue;
            return i;
        }
        return -1;
    }

    public List<SearchRequest> requests() {
        return this.requests;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.requests.isEmpty()) {
            validationException = ValidateActions.addValidationError("no requests added", validationException);
        }
        for (int i = 0; i < this.requests.size(); ++i) {
            ActionRequestValidationException ex = this.requests.get(i).validate();
            if (ex == null) continue;
            if (validationException == null) {
                validationException = new ActionRequestValidationException();
            }
            validationException.addValidationErrors(ex.validationErrors());
        }
        return validationException;
    }

    @Override
    public boolean listenerThreaded() {
        return this.listenerThreaded;
    }

    @Override
    public MultiSearchRequest listenerThreaded(boolean listenerThreaded) {
        this.listenerThreaded = listenerThreaded;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            SearchRequest request = new SearchRequest();
            request.readFrom(in);
            this.requests.add(request);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.requests.size());
        for (SearchRequest request : this.requests) {
            request.writeTo(out);
        }
    }
}

