/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchOperationThreading;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.search.type.TransportSearchCountAction;
import org.elasticsearch.action.search.type.TransportSearchDfsQueryAndFetchAction;
import org.elasticsearch.action.search.type.TransportSearchDfsQueryThenFetchAction;
import org.elasticsearch.action.search.type.TransportSearchQueryAndFetchAction;
import org.elasticsearch.action.search.type.TransportSearchQueryThenFetchAction;
import org.elasticsearch.action.search.type.TransportSearchScanAction;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportService;

public class TransportSearchAction
extends TransportAction<SearchRequest, SearchResponse> {
    private final ClusterService clusterService;
    private final TransportSearchDfsQueryThenFetchAction dfsQueryThenFetchAction;
    private final TransportSearchQueryThenFetchAction queryThenFetchAction;
    private final TransportSearchDfsQueryAndFetchAction dfsQueryAndFetchAction;
    private final TransportSearchQueryAndFetchAction queryAndFetchAction;
    private final TransportSearchScanAction scanAction;
    private final TransportSearchCountAction countAction;
    private final boolean optimizeSingleShard;

    @Inject
    public TransportSearchAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, TransportSearchDfsQueryThenFetchAction dfsQueryThenFetchAction, TransportSearchQueryThenFetchAction queryThenFetchAction, TransportSearchDfsQueryAndFetchAction dfsQueryAndFetchAction, TransportSearchQueryAndFetchAction queryAndFetchAction, TransportSearchScanAction scanAction, TransportSearchCountAction countAction) {
        super(settings, threadPool);
        this.clusterService = clusterService;
        this.dfsQueryThenFetchAction = dfsQueryThenFetchAction;
        this.queryThenFetchAction = queryThenFetchAction;
        this.dfsQueryAndFetchAction = dfsQueryAndFetchAction;
        this.queryAndFetchAction = queryAndFetchAction;
        this.scanAction = scanAction;
        this.countAction = countAction;
        this.optimizeSingleShard = this.componentSettings.getAsBoolean("optimize_single_shard", true);
        transportService.registerHandler("search", new TransportHandler());
    }

    @Override
    protected void doExecute(SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        if (this.optimizeSingleShard && searchRequest.searchType() != SearchType.SCAN && searchRequest.searchType() != SearchType.COUNT) {
            try {
                ClusterState clusterState = this.clusterService.state();
                String[] concreteIndices = clusterState.metaData().concreteIndices(searchRequest.indices(), false, true);
                Map<String, Set<String>> routingMap = clusterState.metaData().resolveSearchRouting(searchRequest.routing(), searchRequest.indices());
                int shardCount = this.clusterService.operationRouting().searchShardsCount(clusterState, searchRequest.indices(), concreteIndices, searchRequest.queryHint(), routingMap, searchRequest.preference());
                if (shardCount == 1) {
                    searchRequest.searchType(SearchType.QUERY_AND_FETCH);
                }
            }
            catch (IndexMissingException e) {
            }
            catch (Exception e) {
                this.logger.debug("failed to optimize search type, continue as normal", e, new Object[0]);
            }
        }
        if (searchRequest.searchType() == SearchType.DFS_QUERY_THEN_FETCH) {
            this.dfsQueryThenFetchAction.execute(searchRequest, listener);
        } else if (searchRequest.searchType() == SearchType.QUERY_THEN_FETCH) {
            this.queryThenFetchAction.execute(searchRequest, listener);
        } else if (searchRequest.searchType() == SearchType.DFS_QUERY_AND_FETCH) {
            this.dfsQueryAndFetchAction.execute(searchRequest, listener);
        } else if (searchRequest.searchType() == SearchType.QUERY_AND_FETCH) {
            this.queryAndFetchAction.execute(searchRequest, listener);
        } else if (searchRequest.searchType() == SearchType.SCAN) {
            this.scanAction.execute(searchRequest, listener);
        } else if (searchRequest.searchType() == SearchType.COUNT) {
            this.countAction.execute(searchRequest, listener);
        }
    }

    private class TransportHandler
    extends BaseTransportRequestHandler<SearchRequest> {
        private TransportHandler() {
        }

        @Override
        public SearchRequest newInstance() {
            return new SearchRequest();
        }

        @Override
        public void messageReceived(SearchRequest request, final TransportChannel channel) throws Exception {
            request.listenerThreaded(false);
            if (request.operationThreading() == SearchOperationThreading.NO_THREADS) {
                request.operationThreading(SearchOperationThreading.SINGLE_THREAD);
            }
            TransportSearchAction.this.execute(request, new ActionListener<SearchResponse>(){

                @Override
                public void onResponse(SearchResponse result) {
                    try {
                        channel.sendResponse(result);
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportSearchAction.this.logger.warn("Failed to send response for search", e1, new Object[0]);
                    }
                }
            });
        }

        @Override
        public String executor() {
            return "same";
        }
    }
}

