/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.update;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.delete.TransportDeleteAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.index.TransportIndexAction;
import org.elasticsearch.action.support.single.instance.TransportInstanceSingleOperationAction;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.routing.PlainShardIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.engine.DocumentSourceMissingException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportUpdateAction
extends TransportInstanceSingleOperationAction<UpdateRequest, UpdateResponse> {
    private final IndicesService indicesService;
    private final TransportDeleteAction deleteAction;
    private final TransportIndexAction indexAction;
    private final ScriptService scriptService;

    @Inject
    public TransportUpdateAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService, TransportIndexAction indexAction, TransportDeleteAction deleteAction, ScriptService scriptService) {
        super(settings, threadPool, clusterService, transportService);
        this.indicesService = indicesService;
        this.indexAction = indexAction;
        this.deleteAction = deleteAction;
        this.scriptService = scriptService;
    }

    @Override
    protected String transportAction() {
        return "update";
    }

    @Override
    protected String executor() {
        return "index";
    }

    @Override
    protected UpdateRequest newRequest() {
        return new UpdateRequest();
    }

    @Override
    protected UpdateResponse newResponse() {
        return new UpdateResponse();
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, UpdateRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, UpdateRequest request) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.WRITE, request.index());
    }

    @Override
    protected boolean retryOnFailure(Throwable e) {
        return (e = ExceptionsHelper.unwrapCause(e)) instanceof IllegalIndexShardStateException;
    }

    @Override
    protected ShardIterator shards(ClusterState clusterState, UpdateRequest request) throws ElasticSearchException {
        ShardRouting shard;
        if (request.shardId() != -1) {
            return clusterState.routingTable().index(request.index()).shard(request.shardId()).primaryShardIt();
        }
        ShardIterator shardIterator = this.clusterService.operationRouting().indexShards(this.clusterService.state(), request.index(), request.type(), request.id(), request.routing());
        while ((shard = shardIterator.nextOrNull()) != null) {
            if (!shard.primary()) continue;
            return new PlainShardIterator(shardIterator.shardId(), ImmutableList.of(shard));
        }
        return new PlainShardIterator(shardIterator.shardId(), ImmutableList.<ShardRouting>of());
    }

    @Override
    protected void shardOperation(UpdateRequest request, ActionListener<UpdateResponse> listener) throws ElasticSearchException {
        this.shardOperation(request, listener, 0);
    }

    protected void shardOperation(final UpdateRequest request, final ActionListener<UpdateResponse> listener, final int retryCount) throws ElasticSearchException {
        String parent;
        IndexService indexService = this.indicesService.indexServiceSafe(request.index());
        IndexShard indexShard = indexService.shardSafe(request.shardId());
        long getDate = System.currentTimeMillis();
        GetResult getResult = indexShard.getService().get(request.type(), request.id(), new String[]{"_source", "_routing", "_parent", "_ttl"}, true);
        if (!getResult.exists()) {
            listener.onFailure(new DocumentMissingException(new ShardId(request.index(), request.shardId()), request.type(), request.id()));
            return;
        }
        if (getResult.internalSourceRef() == null) {
            listener.onFailure(new DocumentSourceMissingException(new ShardId(request.index(), request.shardId()), request.type(), request.id()));
            return;
        }
        Tuple<XContentType, Map<String, Object>> sourceAndContent = XContentHelper.convertToMap(getResult.internalSourceRef().bytes(), getResult.internalSourceRef().offset(), getResult.internalSourceRef().length(), true);
        Map source = sourceAndContent.v2();
        Map ctx = new HashMap<String, Map>(2);
        ctx.put("_source", source);
        try {
            ExecutableScript script = this.scriptService.executable(request.scriptLang, request.script, request.scriptParams);
            script.setNextVar("ctx", ctx);
            script.run();
            ctx = (Map)script.unwrap(ctx);
        }
        catch (Exception e) {
            throw new ElasticSearchIllegalArgumentException("failed to execute script", e);
        }
        String operation = (String)ctx.get("op");
        String timestamp = (String)ctx.get("_timestamp");
        Long ttl = null;
        Object fetchedTTL = ctx.get("_ttl");
        if (fetchedTTL != null) {
            ttl = fetchedTTL instanceof Number ? Long.valueOf(((Number)fetchedTTL).longValue()) : Long.valueOf(TimeValue.parseTimeValue((String)fetchedTTL, null).millis());
        }
        source = (Map)ctx.get("_source");
        String routing = getResult.fields().containsKey("_routing") ? getResult.field("_routing").value().toString() : null;
        String string = parent = getResult.fields().containsKey("_parent") ? getResult.field("_parent").value().toString() : null;
        if (ttl == null) {
            Long l = ttl = getResult.fields().containsKey("_ttl") ? (Long)getResult.field("_ttl").value() : null;
            if (ttl != null) {
                ttl = ttl - (System.currentTimeMillis() - getDate);
            }
        }
        if (operation == null || "index".equals(operation)) {
            IndexRequest indexRequest = Requests.indexRequest(request.index()).type(request.type()).id(request.id()).routing(routing).parent(parent).source(source, sourceAndContent.v1()).version(getResult.version()).replicationType(request.replicationType()).consistencyLevel(request.consistencyLevel()).timestamp(timestamp).ttl(ttl).percolate(request.percolate()).refresh(request.refresh());
            indexRequest.operationThreaded(false);
            this.indexAction.execute(indexRequest, new ActionListener<IndexResponse>(){

                @Override
                public void onResponse(IndexResponse response) {
                    UpdateResponse update = new UpdateResponse(response.index(), response.type(), response.id(), response.version());
                    update.matches(response.matches());
                    listener.onResponse(update);
                }

                @Override
                public void onFailure(Throwable e) {
                    if ((e = ExceptionsHelper.unwrapCause(e)) instanceof VersionConflictEngineException && retryCount < request.retryOnConflict()) {
                        TransportUpdateAction.this.threadPool.executor(TransportUpdateAction.this.executor()).execute(new Runnable(){

                            @Override
                            public void run() {
                                TransportUpdateAction.this.shardOperation(request, listener, retryCount + 1);
                            }
                        });
                        return;
                    }
                    listener.onFailure(e);
                }
            });
        } else if ("delete".equals(operation)) {
            DeleteRequest deleteRequest = Requests.deleteRequest(request.index()).type(request.type()).id(request.id()).routing(routing).parent(parent).version(getResult.version()).replicationType(request.replicationType()).consistencyLevel(request.consistencyLevel());
            deleteRequest.operationThreaded(false);
            this.deleteAction.execute(deleteRequest, new ActionListener<DeleteResponse>(){

                @Override
                public void onResponse(DeleteResponse response) {
                    UpdateResponse update = new UpdateResponse(response.index(), response.type(), response.id(), response.version());
                    listener.onResponse(update);
                }

                @Override
                public void onFailure(Throwable e) {
                    if ((e = ExceptionsHelper.unwrapCause(e)) instanceof VersionConflictEngineException && retryCount < request.retryOnConflict()) {
                        TransportUpdateAction.this.threadPool.executor(TransportUpdateAction.this.executor()).execute(new Runnable(){

                            @Override
                            public void run() {
                                TransportUpdateAction.this.shardOperation(request, listener, retryCount + 1);
                            }
                        });
                        return;
                    }
                    listener.onFailure(e);
                }
            });
        } else if ("none".equals(operation)) {
            listener.onResponse(new UpdateResponse(getResult.index(), getResult.type(), getResult.id(), getResult.version()));
        } else {
            this.logger.warn("Used update operation [{}] for script [{}], doing nothing...", operation, request.script);
            listener.onResponse(new UpdateResponse(getResult.index(), getResult.type(), getResult.id(), getResult.version()));
        }
    }
}

