/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.rest.RestStatus;

public class MetaDataStateIndexService
extends AbstractComponent {
    public static final ClusterBlock INDEX_CLOSED_BLOCK = new ClusterBlock(4, "index closed", false, false, RestStatus.FORBIDDEN, ClusterBlockLevel.READ_WRITE);
    private final ClusterService clusterService;
    private final AllocationService allocationService;

    @Inject
    public MetaDataStateIndexService(Settings settings, ClusterService clusterService, AllocationService allocationService) {
        super(settings);
        this.clusterService = clusterService;
        this.allocationService = allocationService;
    }

    public void closeIndex(final Request request, final Listener listener) {
        this.clusterService.submitStateUpdateTask("close-index [" + request.index + "]", new ProcessedClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                IndexMetaData indexMetaData = currentState.metaData().index(request.index);
                if (indexMetaData == null) {
                    listener.onFailure(new IndexMissingException(new Index(request.index)));
                    return currentState;
                }
                if (indexMetaData.state() == IndexMetaData.State.CLOSE) {
                    listener.onResponse(new Response(true));
                    return currentState;
                }
                MetaDataStateIndexService.this.logger.info("[{}] closing index", request.index);
                MetaData.Builder mdBuilder = MetaData.builder().metaData(currentState.metaData()).put(IndexMetaData.newIndexMetaDataBuilder(currentState.metaData().index(request.index)).state(IndexMetaData.State.CLOSE));
                ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks()).addIndexBlock(request.index, INDEX_CLOSED_BLOCK);
                ClusterState updatedState = ClusterState.builder().state(currentState).metaData(mdBuilder).blocks(blocks).build();
                RoutingTable.Builder rtBuilder = RoutingTable.builder().routingTable(currentState.routingTable()).remove(request.index);
                RoutingAllocation.Result routingResult = MetaDataStateIndexService.this.allocationService.reroute(ClusterState.newClusterStateBuilder().state(updatedState).routingTable(rtBuilder).build());
                return ClusterState.builder().state(updatedState).routingResult(routingResult).build();
            }

            @Override
            public void clusterStateProcessed(ClusterState clusterState) {
                listener.onResponse(new Response(true));
            }
        });
    }

    public void openIndex(final Request request, final Listener listener) {
        this.clusterService.submitStateUpdateTask("open-index [" + request.index + "]", new ProcessedClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                IndexMetaData indexMetaData = currentState.metaData().index(request.index);
                if (indexMetaData == null) {
                    listener.onFailure(new IndexMissingException(new Index(request.index)));
                    return currentState;
                }
                if (indexMetaData.state() == IndexMetaData.State.OPEN) {
                    listener.onResponse(new Response(true));
                    return currentState;
                }
                MetaDataStateIndexService.this.logger.info("[{}] opening index", request.index);
                MetaData.Builder mdBuilder = MetaData.builder().metaData(currentState.metaData()).put(IndexMetaData.newIndexMetaDataBuilder(currentState.metaData().index(request.index)).state(IndexMetaData.State.OPEN));
                ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks()).removeIndexBlock(request.index, INDEX_CLOSED_BLOCK);
                ClusterState updatedState = ClusterState.builder().state(currentState).metaData(mdBuilder).blocks(blocks).build();
                RoutingTable.Builder rtBuilder = RoutingTable.builder().routingTable(updatedState.routingTable());
                IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(request.index).initializeEmpty(updatedState.metaData().index(request.index), false);
                rtBuilder.add(indexRoutingBuilder);
                RoutingAllocation.Result routingResult = MetaDataStateIndexService.this.allocationService.reroute(ClusterState.newClusterStateBuilder().state(updatedState).routingTable(rtBuilder).build());
                return ClusterState.builder().state(updatedState).routingResult(routingResult).build();
            }

            @Override
            public void clusterStateProcessed(ClusterState clusterState) {
                listener.onResponse(new Response(true));
            }
        });
    }

    public static class Response {
        private final boolean acknowledged;

        public Response(boolean acknowledged) {
            this.acknowledged = acknowledged;
        }

        public boolean acknowledged() {
            return this.acknowledged;
        }
    }

    public static class Request {
        final String index;
        TimeValue timeout = TimeValue.timeValueSeconds(10L);

        public Request(String index) {
            this.index = index;
        }

        public Request timeout(TimeValue timeout) {
            this.timeout = timeout;
            return this;
        }
    }

    public static interface Listener {
        public void onResponse(Response var1);

        public void onFailure(Throwable var1);
    }
}

