/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.node;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;

public class DiscoveryNodeFilters {
    public static final DiscoveryNodeFilters NO_FILTERS = new DiscoveryNodeFilters(ImmutableMap.<String, String[]>of());
    private final Map<String, String[]> filters;

    public static DiscoveryNodeFilters buildFromSettings(String prefix, Settings settings) {
        return DiscoveryNodeFilters.buildFromKeyValue(settings.getByPrefix(prefix).getAsMap());
    }

    public static DiscoveryNodeFilters buildFromKeyValue(Map<String, String> filters) {
        HashMap<String, String[]> bFilters = new HashMap<String, String[]>();
        for (Map.Entry<String, String> entry : filters.entrySet()) {
            bFilters.put(entry.getKey(), Strings.splitStringByCommaToArray(entry.getValue()));
        }
        if (bFilters.isEmpty()) {
            return NO_FILTERS;
        }
        return new DiscoveryNodeFilters(bFilters);
    }

    DiscoveryNodeFilters(Map<String, String[]> filters) {
        this.filters = filters;
    }

    public boolean match(DiscoveryNode node) {
        if (this.filters.isEmpty()) {
            return true;
        }
        Iterator<Map.Entry<String, String[]>> i$ = this.filters.entrySet().iterator();
        if (i$.hasNext()) {
            Map.Entry<String, String[]> entry = i$.next();
            String attr = entry.getKey();
            String[] values = entry.getValue();
            if ("_ip".equals(attr)) {
                if (!(node.address() instanceof InetSocketTransportAddress)) {
                    return false;
                }
                InetSocketTransportAddress inetAddress = (InetSocketTransportAddress)node.address();
                for (String value : values) {
                    if (!Regex.simpleMatch(value, inetAddress.address().getAddress().getHostAddress())) continue;
                    return true;
                }
                return false;
            }
            if ("_id".equals(attr)) {
                for (String value : values) {
                    if (!node.id().equals(value)) continue;
                    return true;
                }
                return false;
            }
            if ("_name".equals(attr) || "name".equals(attr)) {
                for (String value : values) {
                    if (!Regex.simpleMatch(value, node.name())) continue;
                    return true;
                }
                return false;
            }
            String nodeAttributeValue = node.attributes().get(attr);
            if (nodeAttributeValue == null) {
                return false;
            }
            for (String value : values) {
                if (!Regex.simpleMatch(value, nodeAttributeValue)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

