/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class ReplicaAfterPrimaryActiveAllocationDecider
extends AllocationDecider {
    @Inject
    public ReplicaAfterPrimaryActiveAllocationDecider(Settings settings) {
        super(settings);
    }

    @Override
    public AllocationDecider.Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (shardRouting.primary()) {
            return AllocationDecider.Decision.YES;
        }
        MutableShardRouting primary = allocation.routingNodes().findPrimaryForReplica(shardRouting);
        if (primary == null || !primary.active()) {
            return AllocationDecider.Decision.NO;
        }
        return AllocationDecider.Decision.YES;
    }
}

