/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.util.List;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.settings.NodeSettingsService;

public class ThrottlingAllocationDecider
extends AllocationDecider {
    private volatile int primariesInitialRecoveries;
    private volatile int concurrentRecoveries;

    @Inject
    public ThrottlingAllocationDecider(Settings settings, NodeSettingsService nodeSettingsService) {
        super(settings);
        this.primariesInitialRecoveries = settings.getAsInt("cluster.routing.allocation.node_initial_primaries_recoveries", settings.getAsInt("cluster.routing.allocation.node_initial_primaries_recoveries", 4));
        this.concurrentRecoveries = settings.getAsInt("cluster.routing.allocation.concurrent_recoveries", settings.getAsInt("cluster.routing.allocation.node_concurrent_recoveries", 2));
        this.logger.debug("using node_concurrent_recoveries [{}], node_initial_primaries_recoveries [{}]", this.concurrentRecoveries, this.primariesInitialRecoveries);
        nodeSettingsService.addListener(new ApplySettings());
    }

    @Override
    public AllocationDecider.Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (shardRouting.primary()) {
            boolean primaryUnassigned = false;
            for (MutableShardRouting shard : allocation.routingNodes().unassigned()) {
                if (!shard.shardId().equals(shardRouting.shardId())) continue;
                primaryUnassigned = true;
            }
            if (primaryUnassigned) {
                int primariesInRecovery = 0;
                List<MutableShardRouting> shards = node.shards();
                for (int i = 0; i < shards.size(); ++i) {
                    MutableShardRouting shard = shards.get(i);
                    if (shard.state() != ShardRoutingState.INITIALIZING || !shard.primary()) continue;
                    ++primariesInRecovery;
                }
                if (primariesInRecovery >= this.primariesInitialRecoveries) {
                    return AllocationDecider.Decision.THROTTLE;
                }
                return AllocationDecider.Decision.YES;
            }
        }
        int currentRecoveries = 0;
        List<MutableShardRouting> shards = node.shards();
        for (int i = 0; i < shards.size(); ++i) {
            MutableShardRouting shard = shards.get(i);
            if (shard.state() != ShardRoutingState.INITIALIZING && shard.state() != ShardRoutingState.RELOCATING) continue;
            ++currentRecoveries;
        }
        if (currentRecoveries >= this.concurrentRecoveries) {
            return AllocationDecider.Decision.THROTTLE;
        }
        return AllocationDecider.Decision.YES;
    }

    static {
        MetaData.addDynamicSettings("cluster.routing.allocation.node_initial_primaries_recoveries", "cluster.routing.allocation.node_concurrent_recoveries");
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            int concurrentRecoveries;
            int primariesInitialRecoveries = settings.getAsInt("cluster.routing.allocation.node_initial_primaries_recoveries", ThrottlingAllocationDecider.this.primariesInitialRecoveries);
            if (primariesInitialRecoveries != ThrottlingAllocationDecider.this.primariesInitialRecoveries) {
                ThrottlingAllocationDecider.this.logger.info("updating [cluster.routing.allocation.node_initial_primaries_recoveries] from [{}] to [{}]", ThrottlingAllocationDecider.this.primariesInitialRecoveries, primariesInitialRecoveries);
                ThrottlingAllocationDecider.this.primariesInitialRecoveries = primariesInitialRecoveries;
            }
            if ((concurrentRecoveries = settings.getAsInt("cluster.routing.allocation.node_concurrent_recoveries", ThrottlingAllocationDecider.this.concurrentRecoveries).intValue()) != ThrottlingAllocationDecider.this.concurrentRecoveries) {
                ThrottlingAllocationDecider.this.logger.info("updating [cluster.routing.allocation.node_concurrent_recoveries] from [{}] to [{}]", ThrottlingAllocationDecider.this.concurrentRecoveries, concurrentRecoveries);
                ThrottlingAllocationDecider.this.concurrentRecoveries = concurrentRecoveries;
            }
        }
    }
}

