/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Queue;
import org.elasticsearch.common.compress.lzf.BufferRecycler;
import org.elasticsearch.common.trove.ExtTDoubleObjectHashMap;
import org.elasticsearch.common.trove.ExtTHashMap;
import org.elasticsearch.common.trove.ExtTLongObjectHashMap;
import org.elasticsearch.common.trove.map.hash.TByteIntHashMap;
import org.elasticsearch.common.trove.map.hash.TDoubleIntHashMap;
import org.elasticsearch.common.trove.map.hash.TFloatIntHashMap;
import org.elasticsearch.common.trove.map.hash.TIntIntHashMap;
import org.elasticsearch.common.trove.map.hash.TLongIntHashMap;
import org.elasticsearch.common.trove.map.hash.TLongLongHashMap;
import org.elasticsearch.common.trove.map.hash.TObjectIntHashMap;
import org.elasticsearch.common.trove.map.hash.TShortIntHashMap;
import org.elasticsearch.common.util.concurrent.jsr166y.LinkedTransferQueue;

public class CacheRecycler {
    private static SoftWrapper<Queue<ExtTHashMap>> hashMap = new SoftWrapper();
    private static SoftWrapper<Queue<ExtTDoubleObjectHashMap>> doubleObjectHashMap = new SoftWrapper();
    private static SoftWrapper<Queue<ExtTLongObjectHashMap>> longObjectHashMap = new SoftWrapper();
    private static SoftWrapper<Queue<TLongLongHashMap>> longLongHashMap = new SoftWrapper();
    private static SoftWrapper<Queue<TIntIntHashMap>> intIntHashMap = new SoftWrapper();
    private static SoftWrapper<Queue<TFloatIntHashMap>> floatIntHashMap = new SoftWrapper();
    private static SoftWrapper<Queue<TDoubleIntHashMap>> doubleIntHashMap = new SoftWrapper();
    private static SoftWrapper<Queue<TByteIntHashMap>> byteIntHashMap = new SoftWrapper();
    private static SoftWrapper<Queue<TShortIntHashMap>> shortIntHashMap = new SoftWrapper();
    private static SoftWrapper<Queue<TLongIntHashMap>> longIntHashMap = new SoftWrapper();
    private static SoftWrapper<Queue<TObjectIntHashMap>> objectIntHashMap = new SoftWrapper();
    private static SoftWrapper<Queue<Object[]>> objectArray = new SoftWrapper();
    private static SoftWrapper<Queue<int[]>> intArray = new SoftWrapper();

    public static void clear() {
        BufferRecycler.clean();
        hashMap.clear();
        doubleObjectHashMap.clear();
        longObjectHashMap.clear();
        longLongHashMap.clear();
        intIntHashMap.clear();
        floatIntHashMap.clear();
        doubleIntHashMap.clear();
        shortIntHashMap.clear();
        longIntHashMap.clear();
        objectIntHashMap.clear();
        objectArray.clear();
        intArray.clear();
    }

    public static <K, V> ExtTHashMap<K, V> popHashMap() {
        Queue<ExtTHashMap> ref = hashMap.get();
        if (ref == null) {
            return new ExtTHashMap();
        }
        ExtTHashMap map = ref.poll();
        if (map == null) {
            return new ExtTHashMap();
        }
        return map;
    }

    public static void pushHashMap(ExtTHashMap map) {
        Queue<ExtTHashMap> ref = hashMap.get();
        if (ref == null) {
            ref = new LinkedTransferQueue<ExtTHashMap>();
            hashMap.set(ref);
        }
        map.clear();
        ref.add(map);
    }

    public static <T> ExtTDoubleObjectHashMap<T> popDoubleObjectMap() {
        Queue<ExtTDoubleObjectHashMap> ref = doubleObjectHashMap.get();
        if (ref == null) {
            return new ExtTDoubleObjectHashMap();
        }
        ExtTDoubleObjectHashMap map = ref.poll();
        if (map == null) {
            return new ExtTDoubleObjectHashMap();
        }
        return map;
    }

    public static void pushDoubleObjectMap(ExtTDoubleObjectHashMap map) {
        Queue<ExtTDoubleObjectHashMap> ref = doubleObjectHashMap.get();
        if (ref == null) {
            ref = new LinkedTransferQueue<ExtTDoubleObjectHashMap>();
            doubleObjectHashMap.set(ref);
        }
        map.clear();
        ref.add(map);
    }

    public static <T> ExtTLongObjectHashMap<T> popLongObjectMap() {
        Queue<ExtTLongObjectHashMap> ref = longObjectHashMap.get();
        if (ref == null) {
            return new ExtTLongObjectHashMap();
        }
        ExtTLongObjectHashMap map = ref.poll();
        if (map == null) {
            return new ExtTLongObjectHashMap();
        }
        return map;
    }

    public static void pushLongObjectMap(ExtTLongObjectHashMap map) {
        Queue<ExtTLongObjectHashMap> ref = longObjectHashMap.get();
        if (ref == null) {
            ref = new LinkedTransferQueue<ExtTLongObjectHashMap>();
            longObjectHashMap.set(ref);
        }
        map.clear();
        ref.add(map);
    }

    public static TLongLongHashMap popLongLongMap() {
        Queue<TLongLongHashMap> ref = longLongHashMap.get();
        if (ref == null) {
            return new TLongLongHashMap();
        }
        TLongLongHashMap map = ref.poll();
        if (map == null) {
            return new TLongLongHashMap();
        }
        return map;
    }

    public static void pushLongLongMap(TLongLongHashMap map) {
        Queue<TLongLongHashMap> ref = longLongHashMap.get();
        if (ref == null) {
            ref = new LinkedTransferQueue<TLongLongHashMap>();
            longLongHashMap.set(ref);
        }
        map.clear();
        ref.add(map);
    }

    public static TIntIntHashMap popIntIntMap() {
        Queue<TIntIntHashMap> ref = intIntHashMap.get();
        if (ref == null) {
            return new TIntIntHashMap();
        }
        TIntIntHashMap map = ref.poll();
        if (map == null) {
            return new TIntIntHashMap();
        }
        return map;
    }

    public static void pushIntIntMap(TIntIntHashMap map) {
        Queue<TIntIntHashMap> ref = intIntHashMap.get();
        if (ref == null) {
            ref = new LinkedTransferQueue<TIntIntHashMap>();
            intIntHashMap.set(ref);
        }
        map.clear();
        ref.add(map);
    }

    public static TFloatIntHashMap popFloatIntMap() {
        Queue<TFloatIntHashMap> ref = floatIntHashMap.get();
        if (ref == null) {
            return new TFloatIntHashMap();
        }
        TFloatIntHashMap map = ref.poll();
        if (map == null) {
            return new TFloatIntHashMap();
        }
        return map;
    }

    public static void pushFloatIntMap(TFloatIntHashMap map) {
        Queue<TFloatIntHashMap> ref = floatIntHashMap.get();
        if (ref == null) {
            ref = new LinkedTransferQueue<TFloatIntHashMap>();
            floatIntHashMap.set(ref);
        }
        map.clear();
        ref.add(map);
    }

    public static TDoubleIntHashMap popDoubleIntMap() {
        Queue<TDoubleIntHashMap> ref = doubleIntHashMap.get();
        if (ref == null) {
            return new TDoubleIntHashMap();
        }
        TDoubleIntHashMap map = ref.poll();
        if (map == null) {
            return new TDoubleIntHashMap();
        }
        return map;
    }

    public static void pushDoubleIntMap(TDoubleIntHashMap map) {
        Queue<TDoubleIntHashMap> ref = doubleIntHashMap.get();
        if (ref == null) {
            ref = new LinkedTransferQueue<TDoubleIntHashMap>();
            doubleIntHashMap.set(ref);
        }
        map.clear();
        ref.add(map);
    }

    public static TByteIntHashMap popByteIntMap() {
        Queue<TByteIntHashMap> ref = byteIntHashMap.get();
        if (ref == null) {
            return new TByteIntHashMap();
        }
        TByteIntHashMap map = ref.poll();
        if (map == null) {
            return new TByteIntHashMap();
        }
        return map;
    }

    public static void pushByteIntMap(TByteIntHashMap map) {
        Queue<TByteIntHashMap> ref = byteIntHashMap.get();
        if (ref == null) {
            ref = new LinkedTransferQueue<TByteIntHashMap>();
            byteIntHashMap.set(ref);
        }
        map.clear();
        ref.add(map);
    }

    public static TShortIntHashMap popShortIntMap() {
        Queue<TShortIntHashMap> ref = shortIntHashMap.get();
        if (ref == null) {
            return new TShortIntHashMap();
        }
        TShortIntHashMap map = ref.poll();
        if (map == null) {
            return new TShortIntHashMap();
        }
        return map;
    }

    public static void pushShortIntMap(TShortIntHashMap map) {
        Queue<TShortIntHashMap> ref = shortIntHashMap.get();
        if (ref == null) {
            ref = new LinkedTransferQueue<TShortIntHashMap>();
            shortIntHashMap.set(ref);
        }
        map.clear();
        ref.add(map);
    }

    public static TLongIntHashMap popLongIntMap() {
        Queue<TLongIntHashMap> ref = longIntHashMap.get();
        if (ref == null) {
            return new TLongIntHashMap();
        }
        TLongIntHashMap map = ref.poll();
        if (map == null) {
            return new TLongIntHashMap();
        }
        return map;
    }

    public static void pushLongIntMap(TLongIntHashMap map) {
        Queue<TLongIntHashMap> ref = longIntHashMap.get();
        if (ref == null) {
            ref = new LinkedTransferQueue<TLongIntHashMap>();
            longIntHashMap.set(ref);
        }
        map.clear();
        ref.add(map);
    }

    public static <T> TObjectIntHashMap<T> popObjectIntMap() {
        Queue<TObjectIntHashMap> ref = objectIntHashMap.get();
        if (ref == null) {
            return new TObjectIntHashMap();
        }
        TObjectIntHashMap map = ref.poll();
        if (map == null) {
            return new TObjectIntHashMap();
        }
        return map;
    }

    public static <T> void pushObjectIntMap(TObjectIntHashMap<T> map) {
        Queue<TObjectIntHashMap> ref = objectIntHashMap.get();
        if (ref == null) {
            ref = new LinkedTransferQueue<TObjectIntHashMap>();
            objectIntHashMap.set(ref);
        }
        map.clear();
        ref.add(map);
    }

    public static Object[] popObjectArray(int size) {
        size = size < 100 ? 100 : size;
        Queue<Object[]> ref = objectArray.get();
        if (ref == null) {
            return new Object[size];
        }
        Object[] objects = ref.poll();
        if (objects == null) {
            return new Object[size];
        }
        if (objects.length < size) {
            return new Object[size];
        }
        return objects;
    }

    public static void pushObjectArray(Object[] objects) {
        Queue<Object[]> ref = objectArray.get();
        if (ref == null) {
            ref = new LinkedTransferQueue<Object[]>();
            objectArray.set(ref);
        }
        Arrays.fill(objects, null);
        ref.add(objects);
    }

    public static int[] popIntArray(int size) {
        return CacheRecycler.popIntArray(size, 0);
    }

    public static int[] popIntArray(int size, int sentinal) {
        size = size < 100 ? 100 : size;
        Queue<int[]> ref = intArray.get();
        if (ref == null) {
            int[] ints = new int[size];
            if (sentinal != 0) {
                Arrays.fill(ints, sentinal);
            }
            return ints;
        }
        int[] ints = ref.poll();
        if (ints == null) {
            ints = new int[size];
            if (sentinal != 0) {
                Arrays.fill(ints, sentinal);
            }
            return ints;
        }
        if (ints.length < size) {
            ints = new int[size];
            if (sentinal != 0) {
                Arrays.fill(ints, sentinal);
            }
            return ints;
        }
        return ints;
    }

    public static void pushIntArray(int[] ints) {
        CacheRecycler.pushIntArray(ints, 0);
    }

    public static void pushIntArray(int[] ints, int sentinal) {
        Queue<int[]> ref = intArray.get();
        if (ref == null) {
            ref = new LinkedTransferQueue<int[]>();
            intArray.set(ref);
        }
        Arrays.fill(ints, sentinal);
        ref.add(ints);
    }

    static class SoftWrapper<T> {
        private SoftReference<T> ref;

        public void set(T ref) {
            this.ref = new SoftReference<T>(ref);
        }

        public T get() {
            return this.ref == null ? null : (T)this.ref.get();
        }

        public void clear() {
            this.ref = null;
        }
    }
}

