/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import java.lang.ref.SoftReference;
import org.elasticsearch.common.io.stream.HandlesStreamInput;
import org.elasticsearch.common.io.stream.LZFStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;

public class CachedStreamInput {
    private static final ThreadLocal<SoftReference<Entry>> cache = new ThreadLocal();

    static Entry instance() {
        Entry entry;
        SoftReference<Entry> ref = cache.get();
        Entry entry2 = entry = ref == null ? null : ref.get();
        if (entry == null) {
            HandlesStreamInput handles = new HandlesStreamInput();
            LZFStreamInput lzf = new LZFStreamInput(null, true);
            entry = new Entry(handles, lzf);
            cache.set(new SoftReference<Entry>(entry));
        }
        return entry;
    }

    public static void clear() {
        cache.remove();
    }

    public static LZFStreamInput cachedLzf(StreamInput in) throws IOException {
        LZFStreamInput lzf = CachedStreamInput.instance().lzf;
        lzf.reset(in);
        return lzf;
    }

    public static HandlesStreamInput cachedHandles(StreamInput in) {
        HandlesStreamInput handles = CachedStreamInput.instance().handles;
        handles.reset(in);
        return handles;
    }

    public static HandlesStreamInput cachedHandlesLzf(StreamInput in) throws IOException {
        Entry entry = CachedStreamInput.instance();
        entry.lzf.reset(in);
        entry.handles.reset(entry.lzf);
        return entry.handles;
    }

    public static char[] getCharArray(int size) {
        Entry entry = CachedStreamInput.instance();
        if (entry.chars.length < size) {
            entry.chars = new char[size];
        }
        return entry.chars;
    }

    static class Entry {
        char[] chars = new char[80];
        final HandlesStreamInput handles;
        final LZFStreamInput lzf;

        Entry(HandlesStreamInput handles, LZFStreamInput lzf) {
            this.handles = handles;
            this.lzf = lzf;
        }
    }
}

