/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.channel;

import java.net.SocketAddress;
import java.util.concurrent.ConcurrentMap;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelFactory;
import org.elasticsearch.common.netty.channel.ChannelFuture;
import org.elasticsearch.common.netty.channel.ChannelPipeline;
import org.elasticsearch.common.netty.channel.ChannelSink;
import org.elasticsearch.common.netty.channel.Channels;
import org.elasticsearch.common.netty.channel.DefaultChannelFuture;
import org.elasticsearch.common.netty.channel.FailedChannelFuture;
import org.elasticsearch.common.netty.channel.SucceededChannelFuture;
import org.elasticsearch.common.netty.util.internal.ConcurrentHashMap;

public abstract class AbstractChannel
implements Channel {
    static final ConcurrentMap<Integer, Channel> allChannels = new ConcurrentHashMap<Integer, Channel>();
    private final Integer id;
    private final Channel parent;
    private final ChannelFactory factory;
    private final ChannelPipeline pipeline;
    private final ChannelFuture succeededFuture = new SucceededChannelFuture(this);
    private final ChannelCloseFuture closeFuture = new ChannelCloseFuture();
    private volatile int interestOps = 1;
    private boolean strValConnected;
    private String strVal;

    private static Integer allocateId(Channel channel) {
        Integer id = System.identityHashCode(channel);
        while (allChannels.putIfAbsent(id, channel) != null) {
            id = id + 1;
        }
        return id;
    }

    protected AbstractChannel(Channel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink) {
        this.parent = parent;
        this.factory = factory;
        this.pipeline = pipeline;
        this.id = AbstractChannel.allocateId(this);
        pipeline.attach(this, sink);
    }

    protected AbstractChannel(Integer id, Channel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink) {
        this.id = id;
        this.parent = parent;
        this.factory = factory;
        this.pipeline = pipeline;
        pipeline.attach(this, sink);
    }

    public final Integer getId() {
        return this.id;
    }

    public Channel getParent() {
        return this.parent;
    }

    public ChannelFactory getFactory() {
        return this.factory;
    }

    public ChannelPipeline getPipeline() {
        return this.pipeline;
    }

    protected ChannelFuture getSucceededFuture() {
        return this.succeededFuture;
    }

    protected ChannelFuture getUnsupportedOperationFuture() {
        return new FailedChannelFuture(this, new UnsupportedOperationException());
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }

    public final boolean equals(Object o) {
        return this == o;
    }

    public final int compareTo(Channel o) {
        return this.getId().compareTo(o.getId());
    }

    public boolean isOpen() {
        return !this.closeFuture.isDone();
    }

    protected boolean setClosed() {
        allChannels.remove(this.id);
        return this.closeFuture.setClosed();
    }

    public ChannelFuture bind(SocketAddress localAddress) {
        return Channels.bind(this, localAddress);
    }

    public ChannelFuture unbind() {
        return Channels.unbind(this);
    }

    public ChannelFuture close() {
        ChannelFuture returnedCloseFuture = Channels.close(this);
        assert (this.closeFuture == returnedCloseFuture);
        return this.closeFuture;
    }

    public ChannelFuture getCloseFuture() {
        return this.closeFuture;
    }

    public ChannelFuture connect(SocketAddress remoteAddress) {
        return Channels.connect(this, remoteAddress);
    }

    public ChannelFuture disconnect() {
        return Channels.disconnect(this);
    }

    public int getInterestOps() {
        return this.interestOps;
    }

    public ChannelFuture setInterestOps(int interestOps) {
        return Channels.setInterestOps(this, interestOps);
    }

    protected void setInterestOpsNow(int interestOps) {
        this.interestOps = interestOps;
    }

    public boolean isReadable() {
        return (this.getInterestOps() & 1) != 0;
    }

    public boolean isWritable() {
        return (this.getInterestOps() & 4) == 0;
    }

    public ChannelFuture setReadable(boolean readable) {
        if (readable) {
            return this.setInterestOps(this.getInterestOps() | 1);
        }
        return this.setInterestOps(this.getInterestOps() & 0xFFFFFFFE);
    }

    public ChannelFuture write(Object message) {
        return Channels.write(this, message);
    }

    public ChannelFuture write(Object message, SocketAddress remoteAddress) {
        return Channels.write(this, message, remoteAddress);
    }

    public String toString() {
        String strVal;
        boolean connected = this.isConnected();
        if (this.strValConnected == connected && this.strVal != null) {
            return this.strVal;
        }
        StringBuilder buf = new StringBuilder(128);
        buf.append("[id: 0x");
        buf.append(this.getIdString());
        SocketAddress localAddress = this.getLocalAddress();
        SocketAddress remoteAddress = this.getRemoteAddress();
        if (remoteAddress != null) {
            buf.append(", ");
            if (this.getParent() == null) {
                buf.append(localAddress);
                buf.append(connected ? " => " : " :> ");
                buf.append(remoteAddress);
            } else {
                buf.append(remoteAddress);
                buf.append(connected ? " => " : " :> ");
                buf.append(localAddress);
            }
        } else if (localAddress != null) {
            buf.append(", ");
            buf.append(localAddress);
        }
        buf.append(']');
        this.strVal = strVal = buf.toString();
        this.strValConnected = connected;
        return strVal;
    }

    private String getIdString() {
        String answer = Integer.toHexString(this.id);
        switch (answer.length()) {
            case 0: {
                answer = "00000000";
                break;
            }
            case 1: {
                answer = "0000000" + answer;
                break;
            }
            case 2: {
                answer = "000000" + answer;
                break;
            }
            case 3: {
                answer = "00000" + answer;
                break;
            }
            case 4: {
                answer = "0000" + answer;
                break;
            }
            case 5: {
                answer = "000" + answer;
                break;
            }
            case 6: {
                answer = "00" + answer;
                break;
            }
            case 7: {
                answer = "0" + answer;
            }
        }
        return answer;
    }

    private final class ChannelCloseFuture
    extends DefaultChannelFuture {
        public ChannelCloseFuture() {
            super(AbstractChannel.this, false);
        }

        public boolean setSuccess() {
            return false;
        }

        public boolean setFailure(Throwable cause) {
            return false;
        }

        boolean setClosed() {
            return super.setSuccess();
        }
    }
}

