/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.compress.lzf.LZF;
import org.elasticsearch.common.io.stream.BytesStreamInput;
import org.elasticsearch.common.io.stream.CachedStreamInput;
import org.elasticsearch.common.io.stream.LZFStreamInput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentGenerator;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public class XContentHelper {
    public static XContentParser createParser(byte[] data, int offset, int length) throws IOException {
        if (LZF.isCompressed(data, offset, length)) {
            BytesStreamInput siBytes = new BytesStreamInput(data, offset, length, false);
            LZFStreamInput siLzf = CachedStreamInput.cachedLzf(siBytes);
            XContentType contentType = XContentFactory.xContentType(siLzf);
            siLzf.resetToBufferStart();
            return XContentFactory.xContent(contentType).createParser(siLzf);
        }
        return XContentFactory.xContent(data, offset, length).createParser(data, offset, length);
    }

    public static Tuple<XContentType, Map<String, Object>> convertToMap(byte[] data, int offset, int length, boolean ordered) throws ElasticSearchParseException {
        try {
            XContentParser parser;
            XContentType contentType;
            if (LZF.isCompressed(data, offset, length)) {
                BytesStreamInput siBytes = new BytesStreamInput(data, offset, length, false);
                LZFStreamInput siLzf = CachedStreamInput.cachedLzf(siBytes);
                contentType = XContentFactory.xContentType(siLzf);
                siLzf.resetToBufferStart();
                parser = XContentFactory.xContent(contentType).createParser(siLzf);
            } else {
                contentType = XContentFactory.xContentType(data, offset, length);
                parser = XContentFactory.xContent(contentType).createParser(data, offset, length);
            }
            if (ordered) {
                return Tuple.tuple(contentType, parser.mapOrderedAndClose());
            }
            return Tuple.tuple(contentType, parser.mapAndClose());
        }
        catch (IOException e) {
            throw new ElasticSearchParseException("Failed to parse content to map", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertToJson(byte[] data, int offset, int length, boolean reformatJson) throws IOException {
        XContentType xContentType = XContentFactory.xContentType(data, offset, length);
        if (xContentType == XContentType.JSON && reformatJson) {
            return new String(data, offset, length, Charsets.UTF_8);
        }
        XContentParser parser = null;
        try {
            parser = XContentFactory.xContent(xContentType).createParser(data, offset, length);
            parser.nextToken();
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.copyCurrentStructure(parser);
            String string = builder.string();
            return string;
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    public static void mergeDefaults(Map<String, Object> content, Map<String, Object> defaults) {
        for (Map.Entry<String, Object> defaultEntry : defaults.entrySet()) {
            if (!content.containsKey(defaultEntry.getKey())) {
                content.put(defaultEntry.getKey(), defaultEntry.getValue());
                continue;
            }
            if (content.get(defaultEntry.getKey()) instanceof Map && defaultEntry.getValue() instanceof Map) {
                XContentHelper.mergeDefaults((Map)content.get(defaultEntry.getKey()), (Map)defaultEntry.getValue());
                continue;
            }
            if (!(content.get(defaultEntry.getKey()) instanceof List) || !(defaultEntry.getValue() instanceof List)) continue;
            List defaultList = (List)defaultEntry.getValue();
            List contentList = (List)content.get(defaultEntry.getKey());
            ArrayList<Map> mergedList = new ArrayList<Map>();
            if (XContentHelper.allListValuesAreMapsOfOne(defaultList) && XContentHelper.allListValuesAreMapsOfOne(contentList)) {
                Map.Entry entry;
                Map map;
                LinkedHashMap processed = Maps.newLinkedHashMap();
                for (Object o : contentList) {
                    map = (Map)o;
                    entry = map.entrySet().iterator().next();
                    processed.put(entry.getKey(), map);
                }
                for (Object o : defaultList) {
                    map = (Map)o;
                    entry = map.entrySet().iterator().next();
                    if (!processed.containsKey(entry.getKey())) continue;
                    XContentHelper.mergeDefaults((Map)processed.get(entry.getKey()), map);
                }
                for (Map map2 : processed.values()) {
                    mergedList.add(map2);
                }
            } else {
                mergedList.addAll((Collection)defaultEntry.getValue());
                mergedList.addAll((Collection)content.get(defaultEntry.getKey()));
            }
            content.put(defaultEntry.getKey(), mergedList);
        }
    }

    private static boolean allListValuesAreMapsOfOne(List list) {
        for (Object o : list) {
            if (!(o instanceof Map)) {
                return false;
            }
            if (((Map)o).size() == 1) continue;
            return false;
        }
        return true;
    }

    public static void copyCurrentStructure(XContentGenerator generator, XContentParser parser) throws IOException {
        XContentParser.Token t = parser.currentToken();
        if (t == XContentParser.Token.FIELD_NAME) {
            generator.writeFieldName(parser.currentName());
            t = parser.nextToken();
        }
        switch (t) {
            case START_ARRAY: {
                generator.writeStartArray();
                while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                    XContentHelper.copyCurrentStructure(generator, parser);
                }
                generator.writeEndArray();
                break;
            }
            case START_OBJECT: {
                generator.writeStartObject();
                while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                    XContentHelper.copyCurrentStructure(generator, parser);
                }
                generator.writeEndObject();
                break;
            }
            default: {
                XContentHelper.copyCurrentEvent(generator, parser);
            }
        }
    }

    public static void copyCurrentEvent(XContentGenerator generator, XContentParser parser) throws IOException {
        switch (parser.currentToken()) {
            case START_OBJECT: {
                generator.writeStartObject();
                break;
            }
            case END_OBJECT: {
                generator.writeEndObject();
                break;
            }
            case START_ARRAY: {
                generator.writeStartArray();
                break;
            }
            case END_ARRAY: {
                generator.writeEndArray();
                break;
            }
            case FIELD_NAME: {
                generator.writeFieldName(parser.currentName());
                break;
            }
            case VALUE_STRING: {
                if (parser.hasTextCharacters()) {
                    generator.writeString(parser.textCharacters(), parser.textOffset(), parser.textLength());
                    break;
                }
                generator.writeString(parser.text());
                break;
            }
            case VALUE_NUMBER: {
                switch (parser.numberType()) {
                    case INT: {
                        generator.writeNumber(parser.intValue());
                        break;
                    }
                    case LONG: {
                        generator.writeNumber(parser.longValue());
                        break;
                    }
                    case FLOAT: {
                        generator.writeNumber(parser.floatValue());
                        break;
                    }
                    case DOUBLE: {
                        generator.writeNumber(parser.doubleValue());
                    }
                }
                break;
            }
            case VALUE_BOOLEAN: {
                generator.writeBoolean(parser.booleanValue());
                break;
            }
            case VALUE_NULL: {
                generator.writeNull();
                break;
            }
            case VALUE_EMBEDDED_OBJECT: {
                generator.writeBinary(parser.binaryValue());
            }
        }
    }
}

