/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.filter.support;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.lucene.docset.DocSets;

public class FilterCacheValue<T> {
    private final T value;

    public FilterCacheValue(T value) {
        this.value = value;
    }

    public T value() {
        return this.value;
    }

    public static DocSet cacheable(IndexReader reader, DocIdSet set) throws IOException {
        if (set == null) {
            return DocSet.EMPTY_DOC_SET;
        }
        if (set == DocIdSet.EMPTY_DOCIDSET) {
            return DocSet.EMPTY_DOC_SET;
        }
        DocIdSetIterator it = set.iterator();
        if (it == null) {
            return DocSet.EMPTY_DOC_SET;
        }
        int doc = it.nextDoc();
        if (doc == Integer.MAX_VALUE) {
            return DocSet.EMPTY_DOC_SET;
        }
        return DocSets.cacheable(reader, set);
    }
}

