/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.core.BinaryFieldMapper;
import org.elasticsearch.index.mapper.core.BooleanFieldMapper;
import org.elasticsearch.index.mapper.core.ByteFieldMapper;
import org.elasticsearch.index.mapper.core.DateFieldMapper;
import org.elasticsearch.index.mapper.core.DoubleFieldMapper;
import org.elasticsearch.index.mapper.core.FloatFieldMapper;
import org.elasticsearch.index.mapper.core.IntegerFieldMapper;
import org.elasticsearch.index.mapper.core.LongFieldMapper;
import org.elasticsearch.index.mapper.core.ShortFieldMapper;
import org.elasticsearch.index.mapper.core.StringFieldMapper;
import org.elasticsearch.index.mapper.geo.GeoPointFieldMapper;
import org.elasticsearch.index.mapper.internal.AllFieldMapper;
import org.elasticsearch.index.mapper.internal.AnalyzerMapper;
import org.elasticsearch.index.mapper.internal.BoostFieldMapper;
import org.elasticsearch.index.mapper.internal.IdFieldMapper;
import org.elasticsearch.index.mapper.internal.IndexFieldMapper;
import org.elasticsearch.index.mapper.internal.ParentFieldMapper;
import org.elasticsearch.index.mapper.internal.RoutingFieldMapper;
import org.elasticsearch.index.mapper.internal.SizeFieldMapper;
import org.elasticsearch.index.mapper.internal.SourceFieldMapper;
import org.elasticsearch.index.mapper.internal.TTLFieldMapper;
import org.elasticsearch.index.mapper.internal.TimestampFieldMapper;
import org.elasticsearch.index.mapper.internal.TypeFieldMapper;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;
import org.elasticsearch.index.mapper.ip.IpFieldMapper;
import org.elasticsearch.index.mapper.multifield.MultiFieldMapper;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.mapper.object.RootObjectMapper;
import org.elasticsearch.index.settings.IndexSettings;

public class DocumentMapperParser
extends AbstractIndexComponent {
    final AnalysisService analysisService;
    private final RootObjectMapper.TypeParser rootObjectTypeParser = new RootObjectMapper.TypeParser();
    private final Object typeParsersMutex = new Object();
    private volatile ImmutableMap<String, Mapper.TypeParser> typeParsers;
    private volatile ImmutableMap<String, Mapper.TypeParser> rootTypeParsers;

    public DocumentMapperParser(Index index, AnalysisService analysisService) {
        this(index, ImmutableSettings.Builder.EMPTY_SETTINGS, analysisService);
    }

    public DocumentMapperParser(Index index, @IndexSettings Settings indexSettings, AnalysisService analysisService) {
        super(index, indexSettings);
        this.analysisService = analysisService;
        this.typeParsers = new MapBuilder<String, ByteFieldMapper.TypeParser>().put("byte", new ByteFieldMapper.TypeParser()).put("short", (ByteFieldMapper.TypeParser)((Object)new ShortFieldMapper.TypeParser())).put("integer", (ByteFieldMapper.TypeParser)((Object)new IntegerFieldMapper.TypeParser())).put("long", (ByteFieldMapper.TypeParser)((Object)new LongFieldMapper.TypeParser())).put("float", (ByteFieldMapper.TypeParser)((Object)new FloatFieldMapper.TypeParser())).put("double", (ByteFieldMapper.TypeParser)((Object)new DoubleFieldMapper.TypeParser())).put("boolean", (ByteFieldMapper.TypeParser)((Object)new BooleanFieldMapper.TypeParser())).put("binary", (ByteFieldMapper.TypeParser)((Object)new BinaryFieldMapper.TypeParser())).put("date", (ByteFieldMapper.TypeParser)((Object)new DateFieldMapper.TypeParser())).put("ip", (ByteFieldMapper.TypeParser)((Object)new IpFieldMapper.TypeParser())).put("string", (ByteFieldMapper.TypeParser)((Object)new StringFieldMapper.TypeParser())).put("object", (ByteFieldMapper.TypeParser)((Object)new ObjectMapper.TypeParser())).put("nested", (ByteFieldMapper.TypeParser)((Object)new ObjectMapper.TypeParser())).put("multi_field", (ByteFieldMapper.TypeParser)((Object)new MultiFieldMapper.TypeParser())).put("geo_point", (ByteFieldMapper.TypeParser)((Object)new GeoPointFieldMapper.TypeParser())).immutableMap();
        this.rootTypeParsers = new MapBuilder<String, SizeFieldMapper.TypeParser>().put("_size", new SizeFieldMapper.TypeParser()).put("_index", (SizeFieldMapper.TypeParser)((Object)new IndexFieldMapper.TypeParser())).put("_source", (SizeFieldMapper.TypeParser)((Object)new SourceFieldMapper.TypeParser())).put("_type", (SizeFieldMapper.TypeParser)((Object)new TypeFieldMapper.TypeParser())).put("_all", (SizeFieldMapper.TypeParser)((Object)new AllFieldMapper.TypeParser())).put("_analyzer", (SizeFieldMapper.TypeParser)((Object)new AnalyzerMapper.TypeParser())).put("_boost", (SizeFieldMapper.TypeParser)((Object)new BoostFieldMapper.TypeParser())).put("_parent", (SizeFieldMapper.TypeParser)((Object)new ParentFieldMapper.TypeParser())).put("_routing", (SizeFieldMapper.TypeParser)((Object)new RoutingFieldMapper.TypeParser())).put("_timestamp", (SizeFieldMapper.TypeParser)((Object)new TimestampFieldMapper.TypeParser())).put("_ttl", (SizeFieldMapper.TypeParser)((Object)new TTLFieldMapper.TypeParser())).put("_uid", (SizeFieldMapper.TypeParser)((Object)new UidFieldMapper.TypeParser())).put("_id", (SizeFieldMapper.TypeParser)((Object)new IdFieldMapper.TypeParser())).immutableMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putTypeParser(String type, Mapper.TypeParser typeParser) {
        Object object = this.typeParsersMutex;
        synchronized (object) {
            this.typeParsers = new MapBuilder<String, Mapper.TypeParser>(this.typeParsers).put(type, typeParser).immutableMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putRootTypeParser(String type, Mapper.TypeParser typeParser) {
        Object object = this.typeParsersMutex;
        synchronized (object) {
            this.rootTypeParsers = new MapBuilder<String, Mapper.TypeParser>().putAll(this.typeParsers).put(type, typeParser).immutableMap();
        }
    }

    public Mapper.TypeParser.ParserContext parserContext() {
        return new Mapper.TypeParser.ParserContext(this.analysisService, this.typeParsers);
    }

    public DocumentMapper parse(String source) throws MapperParsingException {
        return this.parse(null, source);
    }

    public DocumentMapper parse(@Nullable String type, String source) throws MapperParsingException {
        return this.parse(type, source, null);
    }

    public DocumentMapper parse(@Nullable String type, String source, String defaultSource) throws MapperParsingException {
        Tuple<String, Map<String, Object>> t;
        HashMap<String, Object> mapping = null;
        if (source != null) {
            t = this.extractMapping(type, source);
            type = t.v1();
            mapping = t.v2();
        }
        if (mapping == null) {
            mapping = Maps.newHashMap();
        }
        if (type == null) {
            throw new MapperParsingException("Failed to derive type");
        }
        if (defaultSource != null && (t = this.extractMapping("_default_", defaultSource)).v2() != null) {
            XContentHelper.mergeDefaults(mapping, t.v2());
        }
        Mapper.TypeParser.ParserContext parserContext = new Mapper.TypeParser.ParserContext(this.analysisService, this.typeParsers);
        DocumentMapper.Builder docBuilder = MapperBuilders.doc(this.index.name(), this.indexSettings, (RootObjectMapper.Builder)this.rootObjectTypeParser.parse(type, mapping, parserContext));
        for (Map.Entry entry : mapping.entrySet()) {
            NamedAnalyzer analyzer;
            String fieldName = Strings.toUnderscoreCase((String)entry.getKey());
            Object fieldNode = entry.getValue();
            if ("index_analyzer".equals(fieldName)) {
                analyzer = this.analysisService.analyzer(fieldNode.toString());
                if (analyzer == null) {
                    throw new MapperParsingException("Analyzer [" + fieldNode.toString() + "] not found for index_analyzer setting on root type [" + type + "]");
                }
                docBuilder.indexAnalyzer(analyzer);
                continue;
            }
            if ("search_analyzer".equals(fieldName)) {
                analyzer = this.analysisService.analyzer(fieldNode.toString());
                if (analyzer == null) {
                    throw new MapperParsingException("Analyzer [" + fieldNode.toString() + "] not found for search_analyzer setting on root type [" + type + "]");
                }
                docBuilder.searchAnalyzer(analyzer);
                continue;
            }
            if ("search_quote_analyzer".equals(fieldName)) {
                analyzer = this.analysisService.analyzer(fieldNode.toString());
                if (analyzer == null) {
                    throw new MapperParsingException("Analyzer [" + fieldNode.toString() + "] not found for search_analyzer setting on root type [" + type + "]");
                }
                docBuilder.searchQuoteAnalyzer(analyzer);
                continue;
            }
            if ("analyzer".equals(fieldName)) {
                analyzer = this.analysisService.analyzer(fieldNode.toString());
                if (analyzer == null) {
                    throw new MapperParsingException("Analyzer [" + fieldNode.toString() + "] not found for analyzer setting on root type [" + type + "]");
                }
                docBuilder.indexAnalyzer(analyzer);
                docBuilder.searchAnalyzer(analyzer);
                continue;
            }
            Mapper.TypeParser typeParser = this.rootTypeParsers.get(fieldName);
            if (typeParser == null) continue;
            docBuilder.put(typeParser.parse(fieldName, (Map)fieldNode, parserContext));
        }
        if (!docBuilder.hasIndexAnalyzer()) {
            docBuilder.indexAnalyzer(this.analysisService.defaultIndexAnalyzer());
        }
        if (!docBuilder.hasSearchAnalyzer()) {
            docBuilder.searchAnalyzer(this.analysisService.defaultSearchAnalyzer());
        }
        if (!docBuilder.hasSearchQuoteAnalyzer()) {
            docBuilder.searchAnalyzer(this.analysisService.defaultSearchQuoteAnalyzer());
        }
        ImmutableMap<String, Object> attributes = ImmutableMap.of();
        if (mapping.containsKey("_meta")) {
            attributes = ImmutableMap.copyOf((Map)mapping.get("_meta"));
        }
        docBuilder.meta(attributes);
        DocumentMapper documentMapper = docBuilder.build(this);
        documentMapper.refreshSource();
        return documentMapper;
    }

    private Tuple<String, Map<String, Object>> extractMapping(String type, String source) throws MapperParsingException {
        Map<String, Object> root;
        XContentParser xContentParser = null;
        try {
            xContentParser = XContentFactory.xContent(source).createParser(source);
            root = xContentParser.mapOrdered();
        }
        catch (IOException e) {
            throw new MapperParsingException("Failed to parse mapping definition", e);
        }
        finally {
            if (xContentParser != null) {
                xContentParser.close();
            }
        }
        if (root.keySet().size() != 1) {
            throw new MapperParsingException("Mapping must have the `type` as the root object");
        }
        String rootName = root.keySet().iterator().next();
        if (type == null) {
            type = rootName;
        }
        return new Tuple<String, Map<String, Object>>(type, (Map)root.get(rootName));
    }
}

