/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.common.Base64;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.compress.lzf.LZF;
import org.elasticsearch.common.compress.lzf.LZFDecoder;
import org.elasticsearch.common.io.stream.CachedStreamOutput;
import org.elasticsearch.common.io.stream.LZFStreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;

public class BinaryFieldMapper
extends AbstractFieldMapper<byte[]> {
    public static final String CONTENT_TYPE = "binary";
    private Boolean compress;
    private long compressThreshold;

    protected BinaryFieldMapper(FieldMapper.Names names, Field.Store store, Boolean compress, long compressThreshold) {
        super(names, Field.Index.NO, store, Field.TermVector.NO, 1.0f, true, true, null, null);
        this.compress = compress;
        this.compressThreshold = compressThreshold;
    }

    @Override
    public Object valueForSearch(Fieldable field) {
        return this.value(field);
    }

    @Override
    public byte[] value(Fieldable field) {
        byte[] value = field.getBinaryValue();
        if (value != null && LZF.isCompressed(value)) {
            try {
                return LZFDecoder.decode(value);
            }
            catch (IOException e) {
                throw new ElasticSearchParseException("failed to decompress source", e);
            }
        }
        return value;
    }

    @Override
    public byte[] valueFromString(String value) {
        try {
            return Base64.decode(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String valueAsString(Fieldable field) {
        return null;
    }

    @Override
    public String indexedValue(String value) {
        return value;
    }

    @Override
    protected Field parseCreateField(ParseContext context) throws IOException {
        if (!this.stored()) {
            return null;
        }
        if (context.parser().currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        byte[] value = context.parser().binaryValue();
        if (this.compress != null && this.compress.booleanValue() && !LZF.isCompressed(value, 0, value.length) && (this.compressThreshold == -1L || (long)value.length > this.compressThreshold)) {
            CachedStreamOutput.Entry cachedEntry = CachedStreamOutput.popEntry();
            LZFStreamOutput streamOutput = cachedEntry.cachedLZFBytes();
            streamOutput.writeBytes(value, 0, value.length);
            streamOutput.flush();
            value = cachedEntry.bytes().copiedByteArray();
            CachedStreamOutput.pushEntry(cachedEntry);
        }
        if (value == null) {
            return null;
        }
        return new Field(this.names.indexName(), value);
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.names.name());
        builder.field("type", this.contentType());
        if (!this.names.name().equals(this.names.indexNameClean())) {
            builder.field("index_name", this.names.indexNameClean());
        }
        if (this.compress != null) {
            builder.field("compress", (Object)this.compress);
        }
        if (this.compressThreshold != -1L) {
            builder.field("compress_threshold", new ByteSizeValue(this.compressThreshold).toString());
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        BinaryFieldMapper sourceMergeWith = (BinaryFieldMapper)mergeWith;
        if (!mergeContext.mergeFlags().simulate()) {
            if (sourceMergeWith.compress != null) {
                this.compress = sourceMergeWith.compress;
            }
            if (sourceMergeWith.compressThreshold != -1L) {
                this.compressThreshold = sourceMergeWith.compressThreshold;
            }
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.binaryField(name);
            TypeParsers.parseField(builder, name, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (fieldName.equals("compress") && fieldNode != null) {
                    builder.compress(XContentMapValues.nodeBooleanValue(fieldNode));
                    continue;
                }
                if (!fieldName.equals("compress_threshold") || fieldNode == null) continue;
                if (fieldNode instanceof Number) {
                    builder.compressThreshold(((Number)fieldNode).longValue());
                    builder.compress(true);
                    continue;
                }
                builder.compressThreshold(ByteSizeValue.parseBytesSizeValue(fieldNode.toString()).bytes());
                builder.compress(true);
            }
            return builder;
        }
    }

    public static class Builder
    extends AbstractFieldMapper.Builder<Builder, BinaryFieldMapper> {
        private Boolean compress = null;
        private long compressThreshold = -1L;

        public Builder(String name) {
            super(name);
            this.store = Defaults.STORE;
            this.builder = this;
        }

        public Builder compress(boolean compress) {
            this.compress = compress;
            return this;
        }

        public Builder compressThreshold(long compressThreshold) {
            this.compressThreshold = compressThreshold;
            return this;
        }

        @Override
        public Builder indexName(String indexName) {
            return (Builder)super.indexName(indexName);
        }

        @Override
        public BinaryFieldMapper build(Mapper.BuilderContext context) {
            return new BinaryFieldMapper(this.buildNames(context), this.store, this.compress, this.compressThreshold);
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final long COMPRESS_THRESHOLD = -1L;
        public static final Field.Store STORE = Field.Store.YES;
    }
}

