/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.geo;

import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.field.data.DocFieldData;
import org.elasticsearch.index.mapper.geo.GeoPoint;
import org.elasticsearch.index.mapper.geo.GeoPointFieldData;

public class GeoPointDocFieldData
extends DocFieldData<GeoPointFieldData> {
    public GeoPointDocFieldData(GeoPointFieldData fieldData) {
        super(fieldData);
    }

    public GeoPoint getValue() {
        return ((GeoPointFieldData)this.fieldData).value(this.docId);
    }

    public GeoPoint[] getValues() {
        return ((GeoPointFieldData)this.fieldData).values(this.docId);
    }

    public double factorDistance(double lat, double lon) {
        return ((GeoPointFieldData)this.fieldData).factorDistance(this.docId, DistanceUnit.MILES, lat, lon);
    }

    public double factorDistance02(double lat, double lon) {
        return ((GeoPointFieldData)this.fieldData).factorDistance(this.docId, DistanceUnit.MILES, lat, lon) + 1.0;
    }

    public double factorDistance13(double lat, double lon) {
        return ((GeoPointFieldData)this.fieldData).factorDistance(this.docId, DistanceUnit.MILES, lat, lon) + 2.0;
    }

    public double arcDistance(double lat, double lon) {
        return ((GeoPointFieldData)this.fieldData).arcDistance(this.docId, DistanceUnit.MILES, lat, lon);
    }

    public double arcDistanceInKm(double lat, double lon) {
        return ((GeoPointFieldData)this.fieldData).arcDistance(this.docId, DistanceUnit.KILOMETERS, lat, lon);
    }

    public double distance(double lat, double lon) {
        return ((GeoPointFieldData)this.fieldData).distance(this.docId, DistanceUnit.MILES, lat, lon);
    }

    public double distanceInKm(double lat, double lon) {
        return ((GeoPointFieldData)this.fieldData).distance(this.docId, DistanceUnit.KILOMETERS, lat, lon);
    }

    public double geohashDistance(String geohash) {
        return ((GeoPointFieldData)this.fieldData).distanceGeohash(this.docId, DistanceUnit.MILES, geohash);
    }

    public double geohashDistanceInKm(String geohash) {
        return ((GeoPointFieldData)this.fieldData).distanceGeohash(this.docId, DistanceUnit.KILOMETERS, geohash);
    }

    public double getLat() {
        return ((GeoPointFieldData)this.fieldData).latValue(this.docId);
    }

    public double getLon() {
        return ((GeoPointFieldData)this.fieldData).lonValue(this.docId);
    }

    public double[] getLats() {
        return ((GeoPointFieldData)this.fieldData).latValues(this.docId);
    }

    public double[] getLons() {
        return ((GeoPointFieldData)this.fieldData).lonValues(this.docId);
    }
}

