/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.script.SearchScript;

public class CustomScoreQueryParser
implements QueryParser {
    public static final String NAME = "custom_score";

    @Inject
    public CustomScoreQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        Query query = null;
        float boost = 1.0f;
        String script = null;
        String scriptLang = null;
        Map<String, Object> vars = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("query".equals(currentFieldName)) {
                    query = parseContext.parseInnerQuery();
                    continue;
                }
                if ("params".equals(currentFieldName)) {
                    vars = parser.map();
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[custom_score] query does not support [" + currentFieldName + "]");
            }
            if (!token.isValue()) continue;
            if ("script".equals(currentFieldName)) {
                script = parser.text();
                continue;
            }
            if ("lang".equals(currentFieldName)) {
                scriptLang = parser.text();
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[custom_score] query does not support [" + currentFieldName + "]");
        }
        if (query == null) {
            throw new QueryParsingException(parseContext.index(), "[custom_score] requires 'query' field");
        }
        if (script == null) {
            throw new QueryParsingException(parseContext.index(), "[custom_score] requires 'script' field");
        }
        SearchScript searchScript = parseContext.scriptService().search(parseContext.lookup(), scriptLang, script, vars);
        FunctionScoreQuery functionScoreQuery = new FunctionScoreQuery(query, new ScriptScoreFunction(script, vars, searchScript));
        functionScoreQuery.setBoost(boost);
        return functionScoreQuery;
    }

    public static class ScriptScoreFunction
    implements ScoreFunction {
        private final String sScript;
        private final Map<String, Object> params;
        private final SearchScript script;

        public ScriptScoreFunction(String sScript, Map<String, Object> params, SearchScript script) {
            this.sScript = sScript;
            this.params = params;
            this.script = script;
        }

        @Override
        public void setNextReader(IndexReader reader) {
            this.script.setNextReader(reader);
        }

        @Override
        public float score(int docId, float subQueryScore) {
            this.script.setNextDocId(docId);
            this.script.setNextScore(subQueryScore);
            return this.script.runAsFloat();
        }

        @Override
        public float factor(int docId) {
            this.script.setNextDocId(docId);
            return this.script.runAsFloat();
        }

        @Override
        public Explanation explainScore(int docId, Explanation subQueryExpl) {
            float score = this.score(docId, subQueryExpl.getValue());
            Explanation exp = new Explanation(score, "script score function: product of:");
            exp.addDetail(subQueryExpl);
            return exp;
        }

        @Override
        public Explanation explainFactor(int docId) {
            return new Explanation(this.factor(docId), "scriptFactor");
        }

        public String toString() {
            return "script[" + this.sScript + "], params [" + this.params + "]";
        }
    }
}

