/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.HashSet;
import org.apache.lucene.search.Filter;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;

public class IndicesFilterParser
implements FilterParser {
    public static final String NAME = "indices";
    @Nullable
    private final ClusterService clusterService;

    @Inject
    public IndicesFilterParser(@Nullable ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        Filter filter = null;
        HashSet<String> indices = Sets.newHashSet();
        String currentFieldName = null;
        Filter noMatchFilter = Queries.MATCH_ALL_FILTER;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("filter".equals(currentFieldName)) {
                    filter = parseContext.parseInnerFilter();
                    continue;
                }
                if ("no_match_filter".equals(currentFieldName)) {
                    noMatchFilter = parseContext.parseInnerFilter();
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[indices] filter does not support [" + currentFieldName + "]");
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (NAME.equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        String value = parser.textOrNull();
                        if (value == null) {
                            throw new QueryParsingException(parseContext.index(), "No value specified for term filter");
                        }
                        indices.add(value);
                    }
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[indices] filter does not support [" + currentFieldName + "]");
            }
            if (!token.isValue()) continue;
            if ("index".equals(currentFieldName)) {
                indices.add(parser.text());
                continue;
            }
            if ("no_match_filter".equals(currentFieldName)) {
                String type = parser.text();
                if ("all".equals(type)) {
                    noMatchFilter = Queries.MATCH_ALL_FILTER;
                    continue;
                }
                if (!"none".equals(type)) continue;
                noMatchFilter = Queries.MATCH_NO_FILTER;
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[indices] filter does not support [" + currentFieldName + "]");
        }
        if (filter == null) {
            throw new QueryParsingException(parseContext.index(), "[indices] requires 'filter' element");
        }
        if (indices.isEmpty()) {
            throw new QueryParsingException(parseContext.index(), "[indices] requires 'indices' element");
        }
        String[] concreteIndices = indices.toArray(new String[indices.size()]);
        if (this.clusterService != null) {
            MetaData metaData = this.clusterService.state().metaData();
            concreteIndices = metaData.concreteIndices(indices.toArray(new String[indices.size()]), true, true);
        }
        for (String index : concreteIndices) {
            if (!Regex.simpleMatch(index, parseContext.index().name())) continue;
            return filter;
        }
        return noMatchFilter;
    }
}

