/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.DeletionAwareConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.NestedQueryParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.search.nested.BlockJoinQuery;
import org.elasticsearch.index.search.nested.NonNestedDocsFilter;
import org.elasticsearch.search.internal.SearchContext;

public class NestedFilterParser
implements FilterParser {
    public static final String NAME = "nested";

    @Inject
    public NestedFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser parser = parseContext.parser();
        Query query = null;
        Filter filter = null;
        float boost = 1.0f;
        String scope = null;
        String path = null;
        boolean cache = false;
        CacheKeyFilter.Key cacheKey = null;
        String filterName = null;
        NestedQueryParser.LateBindingParentFilter currentParentFilterContext = NestedQueryParser.parentFilterContext.get();
        NestedQueryParser.LateBindingParentFilter usAsParentFilter = new NestedQueryParser.LateBindingParentFilter();
        NestedQueryParser.parentFilterContext.set(usAsParentFilter);
        try {
            Filter childFilter;
            XContentParser.Token token;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("query".equals(currentFieldName)) {
                        query = parseContext.parseInnerQuery();
                        continue;
                    }
                    if ("filter".equals(currentFieldName)) {
                        filter = parseContext.parseInnerFilter();
                        continue;
                    }
                    throw new QueryParsingException(parseContext.index(), "[nested] filter does not support [" + currentFieldName + "]");
                }
                if (!token.isValue()) continue;
                if ("path".equals(currentFieldName)) {
                    path = parser.text();
                    continue;
                }
                if ("boost".equals(currentFieldName)) {
                    boost = parser.floatValue();
                    continue;
                }
                if ("_scope".equals(currentFieldName)) {
                    scope = parser.text();
                    continue;
                }
                if ("_name".equals(currentFieldName)) {
                    filterName = parser.text();
                    continue;
                }
                if ("_cache".equals(currentFieldName)) {
                    cache = parser.booleanValue();
                    continue;
                }
                if ("_cache_key".equals(currentFieldName) || "_cacheKey".equals(currentFieldName)) {
                    cacheKey = new CacheKeyFilter.Key(parser.text());
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[nested] filter does not support [" + currentFieldName + "]");
            }
            if (query == null && filter == null) {
                throw new QueryParsingException(parseContext.index(), "[nested] requires either 'query' or 'filter' field");
            }
            if (path == null) {
                throw new QueryParsingException(parseContext.index(), "[nested] requires 'path' field");
            }
            if (filter != null) {
                query = new DeletionAwareConstantScoreQuery(filter);
            }
            query.setBoost(boost);
            MapperService.SmartNameObjectMapper mapper = parseContext.smartObjectMapper(path);
            if (mapper == null) {
                throw new QueryParsingException(parseContext.index(), "[nested] failed to find nested object under path [" + path + "]");
            }
            ObjectMapper objectMapper = mapper.mapper();
            if (objectMapper == null) {
                throw new QueryParsingException(parseContext.index(), "[nested] failed to find nested object under path [" + path + "]");
            }
            if (!objectMapper.nested().isNested()) {
                throw new QueryParsingException(parseContext.index(), "[nested] nested object under path [" + path + "] is not of nested type");
            }
            usAsParentFilter.filter = childFilter = parseContext.cacheFilter(objectMapper.nestedTypeFilter(), null);
            query = new FilteredQuery(query, childFilter);
            Filter parentFilter = currentParentFilterContext;
            if (parentFilter == null) {
                parentFilter = NonNestedDocsFilter.INSTANCE;
                parentFilter = parseContext.cacheFilter(parentFilter, null);
            }
            BlockJoinQuery joinQuery = new BlockJoinQuery(query, parentFilter, BlockJoinQuery.ScoreMode.None);
            if (scope != null) {
                SearchContext.current().addNestedQuery(scope, joinQuery);
            }
            Filter joinFilter = new QueryWrapperFilter(joinQuery);
            if (cache) {
                joinFilter = parseContext.cacheFilter(joinFilter, cacheKey);
            }
            if (filterName != null) {
                parseContext.addNamedFilter(filterName, joinFilter);
            }
            QueryWrapperFilter queryWrapperFilter = joinFilter;
            return queryWrapperFilter;
        }
        finally {
            NestedQueryParser.parentFilterContext.set(currentParentFilterContext);
        }
    }
}

