/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.QueryBuilderException;
import org.elasticsearch.index.query.SpanQueryBuilder;

public class SpanOrQueryBuilder
extends BaseQueryBuilder
implements SpanQueryBuilder {
    private ArrayList<SpanQueryBuilder> clauses = new ArrayList();
    private float boost = -1.0f;

    public SpanOrQueryBuilder clause(SpanQueryBuilder clause) {
        this.clauses.add(clause);
        return this;
    }

    public SpanOrQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.clauses.isEmpty()) {
            throw new QueryBuilderException("Must have at least one clause when building a spanOr query");
        }
        builder.startObject("span_or");
        builder.startArray("clauses");
        for (SpanQueryBuilder clause : this.clauses) {
            clause.toXContent(builder, params);
        }
        builder.endArray();
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        builder.endObject();
    }
}

