/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.common.Unicode;
import org.elasticsearch.common.bloom.BloomFilter;
import org.elasticsearch.index.cache.bloom.BloomCache;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;

public class UidFilter
extends Filter {
    private final Set<Term> uids;
    private final BloomCache bloomCache;

    public UidFilter(Collection<String> types, List<String> ids, BloomCache bloomCache) {
        this.bloomCache = bloomCache;
        this.uids = new TreeSet<Term>();
        for (String type : types) {
            for (String id : ids) {
                this.uids.add(UidFieldMapper.TERM_FACTORY.createTerm(Uid.createUid(type, id)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        BloomFilter filter = this.bloomCache.filter(reader, "_uid", true);
        FixedBitSet set = null;
        TermDocs td = null;
        try {
            for (Term uid : this.uids) {
                UnicodeUtil.UTF8Result utf8 = Unicode.fromStringAsUtf8(uid.text());
                if (!filter.isPresent(utf8.result, 0, utf8.length)) continue;
                if (td == null) {
                    td = reader.termDocs();
                }
                td.seek(uid);
                while (td.next()) {
                    if (set == null) {
                        set = new FixedBitSet(reader.maxDoc());
                    }
                    set.set(td.doc());
                }
            }
        }
        finally {
            if (td != null) {
                td.close();
            }
        }
        return set;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UidFilter uidFilter = (UidFilter)o;
        return !((Object)this.uids).equals(uidFilter.uids);
    }

    public String toString() {
        return "UidFilter(" + this.uids + ")";
    }

    public int hashCode() {
        return ((Object)this.uids).hashCode();
    }
}

