/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.geo;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.lucene.docset.AndDocSet;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.lucene.docset.DocSets;
import org.elasticsearch.common.lucene.docset.GetDocSet;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.mapper.geo.GeoPointFieldData;
import org.elasticsearch.index.mapper.geo.GeoPointFieldDataType;
import org.elasticsearch.index.mapper.geo.GeoPointFieldMapper;
import org.elasticsearch.index.search.geo.GeoDistance;
import org.elasticsearch.index.search.geo.IndexedGeoBoundingBoxFilter;

public class GeoDistanceRangeFilter
extends Filter {
    private final double lat;
    private final double lon;
    private final double inclusiveLowerPoint;
    private final double inclusiveUpperPoint;
    private final GeoDistance geoDistance;
    private final GeoDistance.FixedSourceDistance fixedSourceDistance;
    private GeoDistance.DistanceBoundingCheck distanceBoundingCheck;
    private final Filter boundingBoxFilter;
    private final String fieldName;
    private final FieldDataCache fieldDataCache;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GeoDistanceRangeFilter(double lat, double lon, Double lowerVal, Double upperVal, boolean includeLower, boolean includeUpper, GeoDistance geoDistance, String fieldName, GeoPointFieldMapper mapper, FieldDataCache fieldDataCache, String optimizeBbox) {
        long i;
        double f;
        this.lat = lat;
        this.lon = lon;
        this.geoDistance = geoDistance;
        this.fieldName = fieldName;
        this.fieldDataCache = fieldDataCache;
        this.fixedSourceDistance = geoDistance.fixedSourceDistance(lat, lon, DistanceUnit.MILES);
        if (lowerVal != null) {
            f = lowerVal;
            i = NumericUtils.doubleToSortableLong(f);
            this.inclusiveLowerPoint = NumericUtils.sortableLongToDouble(includeLower ? i : i + 1L);
        } else {
            this.inclusiveLowerPoint = Double.NEGATIVE_INFINITY;
        }
        if (upperVal != null) {
            f = upperVal;
            i = NumericUtils.doubleToSortableLong(f);
            this.inclusiveUpperPoint = NumericUtils.sortableLongToDouble(includeUpper ? i : i - 1L);
        } else {
            this.inclusiveUpperPoint = Double.POSITIVE_INFINITY;
            optimizeBbox = null;
        }
        if (optimizeBbox != null && !"none".equals(optimizeBbox)) {
            this.distanceBoundingCheck = GeoDistance.distanceBoundingCheck(lat, lon, this.inclusiveUpperPoint, DistanceUnit.MILES);
            if ("memory".equals(optimizeBbox)) {
                this.boundingBoxFilter = null;
                return;
            } else {
                if (!"indexed".equals(optimizeBbox)) throw new ElasticSearchIllegalArgumentException("type [" + optimizeBbox + "] for bounding box optimization not supported");
                this.boundingBoxFilter = IndexedGeoBoundingBoxFilter.create(this.distanceBoundingCheck.topLeft(), this.distanceBoundingCheck.bottomRight(), mapper);
                this.distanceBoundingCheck = GeoDistance.ALWAYS_INSTANCE;
            }
            return;
        } else {
            this.distanceBoundingCheck = GeoDistance.ALWAYS_INSTANCE;
            this.boundingBoxFilter = null;
        }
    }

    public double lat() {
        return this.lat;
    }

    public double lon() {
        return this.lon;
    }

    public GeoDistance geoDistance() {
        return this.geoDistance;
    }

    public String fieldName() {
        return this.fieldName;
    }

    @Override
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        DocSet boundingBoxDocSet = null;
        if (this.boundingBoxFilter != null) {
            DocIdSet docIdSet = this.boundingBoxFilter.getDocIdSet(reader);
            if (docIdSet == null) {
                return null;
            }
            boundingBoxDocSet = DocSets.convert(reader, docIdSet);
        }
        GeoPointFieldData fieldData = (GeoPointFieldData)this.fieldDataCache.cache(GeoPointFieldDataType.TYPE, reader, this.fieldName);
        GeoDistanceRangeDocSet distDocSet = new GeoDistanceRangeDocSet(reader.maxDoc(), fieldData, this.fixedSourceDistance, this.distanceBoundingCheck, this.inclusiveLowerPoint, this.inclusiveUpperPoint);
        if (boundingBoxDocSet == null) {
            return distDocSet;
        }
        return new AndDocSet(ImmutableList.of(boundingBoxDocSet, distDocSet));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoDistanceRangeFilter filter = (GeoDistanceRangeFilter)o;
        if (Double.compare(filter.inclusiveLowerPoint, this.inclusiveLowerPoint) != 0) {
            return false;
        }
        if (Double.compare(filter.inclusiveUpperPoint, this.inclusiveUpperPoint) != 0) {
            return false;
        }
        if (Double.compare(filter.lat, this.lat) != 0) {
            return false;
        }
        if (Double.compare(filter.lon, this.lon) != 0) {
            return false;
        }
        if (this.fieldName != null ? !this.fieldName.equals(filter.fieldName) : filter.fieldName != null) {
            return false;
        }
        return this.geoDistance == filter.geoDistance;
    }

    public String toString() {
        return "GeoDistanceRangeFilter(" + this.fieldName + ", " + (Object)((Object)this.geoDistance) + ", [" + this.inclusiveLowerPoint + " - " + this.inclusiveUpperPoint + "], " + this.lat + ", " + this.lon + ")";
    }

    public int hashCode() {
        long temp = this.lat != 0.0 ? Double.doubleToLongBits(this.lat) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.lon != 0.0 ? Double.doubleToLongBits(this.lon) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.inclusiveLowerPoint != 0.0 ? Double.doubleToLongBits(this.inclusiveLowerPoint) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.inclusiveUpperPoint != 0.0 ? Double.doubleToLongBits(this.inclusiveUpperPoint) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.geoDistance != null ? this.geoDistance.hashCode() : 0);
        result = 31 * result + (this.fieldName != null ? this.fieldName.hashCode() : 0);
        return result;
    }

    public static class GeoDistanceRangeDocSet
    extends GetDocSet {
        private final GeoPointFieldData fieldData;
        private final GeoDistance.FixedSourceDistance fixedSourceDistance;
        private final GeoDistance.DistanceBoundingCheck distanceBoundingCheck;
        private final double inclusiveLowerPoint;
        private final double inclusiveUpperPoint;

        public GeoDistanceRangeDocSet(int maxDoc, GeoPointFieldData fieldData, GeoDistance.FixedSourceDistance fixedSourceDistance, GeoDistance.DistanceBoundingCheck distanceBoundingCheck, double inclusiveLowerPoint, double inclusiveUpperPoint) {
            super(maxDoc);
            this.fieldData = fieldData;
            this.fixedSourceDistance = fixedSourceDistance;
            this.distanceBoundingCheck = distanceBoundingCheck;
            this.inclusiveLowerPoint = inclusiveLowerPoint;
            this.inclusiveUpperPoint = inclusiveUpperPoint;
        }

        @Override
        public boolean isCacheable() {
            return false;
        }

        @Override
        public boolean get(int doc) {
            double d;
            double lon;
            if (!this.fieldData.hasValue(doc)) {
                return false;
            }
            if (this.fieldData.multiValued()) {
                double[] lats = this.fieldData.latValues(doc);
                double[] lons = this.fieldData.lonValues(doc);
                for (int i = 0; i < lats.length; ++i) {
                    double d2;
                    double lat = lats[i];
                    double lon2 = lons[i];
                    if (!this.distanceBoundingCheck.isWithin(lat, lon2) || !((d2 = this.fixedSourceDistance.calculate(lat, lon2)) >= this.inclusiveLowerPoint) || !(d2 <= this.inclusiveUpperPoint)) continue;
                    return true;
                }
                return false;
            }
            double lat = this.fieldData.latValue(doc);
            return this.distanceBoundingCheck.isWithin(lat, lon = this.fieldData.lonValue(doc)) && (d = this.fixedSourceDistance.calculate(lat, lon)) >= this.inclusiveLowerPoint && d <= this.inclusiveUpperPoint;
        }
    }
}

